# -*- coding: UTF-8 -*-
LANG_TEXT = {
"en_GB": {
	"tr_CY": "Turkish",
	"fr_FR": "French",
	"fi_FI": "Finnish",
	"pt_PT": "Portuguese",
	"fy_NL": "Frisian",
	"it_IT": "Italian",
	"et_EE": "Estonian",
	"nb_NO": "Norwegian",
	"nl_NL": "Dutch",
	"lv_LV": "Latvian",
	"el_GR": "Greek",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hungarian",
	"lt_LT": "Lithuanian",
	"sl_SI": "Slovenian",
	"hr_HR": "Croatian",
	"en_GB": "English",
	"es_ES": "Spanish",
	"ca_AD": "Catalan",
	"ru_RU": "Russian",
	"is_IS": "Icelandic",
	"da_DK": "Danish",
	"ar_AE": "Arabic",
	"sk_SK": "Slovakian",
	"de_DE": "German",
	"sr_RS": "Serbian",
	"cs_CZ": "Czech",
	"pl_PL": "Polish",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Swedish",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Language selection",
},
"de_DE": {
	"tr_CY": "Türkisch",
	"fr_FR": "Französisch",
	"fi_FI": "Finnisch",
	"pt_PT": "portugiesisch",
	"fy_NL": "Friesisch",
	"it_IT": "Italienisch",
	"et_EE": "Estnisch",
	"nb_NO": "Norwegisch",
	"nl_NL": "Holländisch",
	"lv_LV": "Lettisch",
	"el_GR": "Griechisch",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungarisch",
	"lt_LT": "litauisch",
	"sl_SI": "Slowenisch",
	"hr_HR": "Kroatisch",
	"en_GB": "Englisch",
	"es_ES": "Spanisch",
	"ca_AD": "Katalanisch",
	"ru_RU": "Russisch",
	"is_IS": "Isländisch",
	"da_DK": "Dänisch",
	"ar_AE": "Arabisch",
	"sk_SK": "Slowakisch",
	"de_DE": "Deutsch",
	"sr_RS": "Serbisch",
	"cs_CZ": "Tschechisch",
	"pl_PL": "Polnisch",
	"uk_UA": "Ukrainisch",
	"fa_IR": "Persisch",
	"sv_SE": "Schwedisch",
	"he_IL": "Hebräisch",
	"T1": "Bitte benutzen Sie die Hoch/Runter-Tasten, um Ihre Sprache auszuwählen. Danach drücken Sie bitte OK.",
	"T2": "Sprachauswahl",
},
"ar_AE": {
	"tr_CY": "تركى",
	"fr_FR": "فرنسى",
	"fi_FI": "إنتهاء",
	"pt_PT": "برتغالى",
	"fy_NL": "Frisian",
	"it_IT": "إيطالى",
	"et_EE": "أستونى",
	"nb_NO": "نرويجى",
	"nl_NL": "هولندى",
	"lv_LV": "Latvian",
	"el_GR": "اليونان",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "مجرى",
	"lt_LT": "ليتوانى",
	"sl_SI": "سلوفانى",
	"hr_HR": "كرواتى",
	"en_GB": "إنجليزى",
	"es_ES": "أسبانى",
	"ca_AD": "كاتالاني",
	"ru_RU": "روسى",
	"is_IS": "ايسلندى",
	"da_DK": "دنماركى",
	"ar_AE": "عـربى",
	"sk_SK": "سلوفاكى",
	"de_DE": "المانـى",
	"sr_RS": "صريى",
	"cs_CZ": "التشيك",
	"pl_PL": "بولندى",
	"uk_UA": "أوكرانى",
	"fa_IR": "Persian",
	"sv_SE": "سويدى",
	"he_IL": "Hebrew",
	"T1": "من فضلك أستخدم ذر السهم العلوى أو السفلى لإختيار اللغه. ثم أضغط موافق .",
	"T2": "إختيار اللغـه",
},
"pt_BR": {
	"tr_CY": "Turco",
	"fr_FR": "Francês",
	"fi_FI": "Finlandês",
	"pt_PT": "Português brasileiro",
	"fy_NL": "Frísio",
	"it_IT": "Italiano",
	"et_EE": "Estoniano",
	"nb_NO": "Norueguês",
	"nl_NL": "Holandês",
	"lv_LV": "Letão",
	"el_GR": "Grego",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Húngaro",
	"lt_LT": "Lituano",
	"sl_SI": "Esloveno",
	"hr_HR": "Croata",
	"en_GB": "Inglês",
	"es_ES": "Catalão",
	"ca_AD": "Catalão",
	"ru_RU": "Russo",
	"is_IS": "Islandês",
	"da_DK": "Dinamarquês",
	"ar_AE": "Árabe",
	"sk_SK": "Eslovaco",
	"de_DE": "Alemão",
	"sr_RS": "Sérvia",
	"cs_CZ": "Checo",
	"pl_PL": "Polaco",
	"uk_UA": "Ucraniano",
	"fa_IR": "Persa",
	"sv_SE": "Sueco",
	"he_IL": "Hebráico",
	"T1": "Use a tecla de cima ou de baixo para selecionar seu idioma. Depois pressione OK.",
	"T2": "Seleção do idioma",
},
"ca_AD": {
	"tr_CY": "Turc",
	"fr_FR": "Francès",
	"fi_FI": "Finlandès",
	"pt_PT": "Portuguès",
	"fy_NL": "Frisian",
	"it_IT": "Italià",
	"et_EE": "Estonian",
	"nb_NO": "Noruec",
	"nl_NL": "Holandès",
	"lv_LV": "Latvian",
	"el_GR": "Grec",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hongarès",
	"lt_LT": "Lituà",
	"sl_SI": "Slovenian",
	"hr_HR": "Croat",
	"en_GB": "Anglès",
	"es_ES": "Espanyol",
	"ca_AD": "Català",
	"ru_RU": "Rus",
	"is_IS": "Islandès",
	"da_DK": "Danès",
	"ar_AE": "Àrab",
	"sk_SK": "Slovakian",
	"de_DE": "Alemany",
	"sr_RS": "Serbian",
	"cs_CZ": "Txec",
	"pl_PL": "Polish",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Suec",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Selecció d'idioma",
},
"hr_HR": {
	"tr_CY": "Turski",
	"fr_FR": "Francuski",
	"fi_FI": "Finski",
	"pt_PT": "Portugalski",
	"fy_NL": "Frisian",
	"it_IT": "Talijanski",
	"et_EE": "Estonian",
	"nb_NO": "Norveški",
	"nl_NL": "Nizozemski",
	"lv_LV": "Latvian",
	"el_GR": "Grčki",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Mađarski",
	"lt_LT": "Litvanski",
	"sl_SI": "Slovenian",
	"hr_HR": "Hrvatski",
	"en_GB": "Engleski",
	"es_ES": "Španjolski",
	"ca_AD": "Katalonski",
	"ru_RU": "Ruski",
	"is_IS": "Islandski",
	"da_DK": "Danski",
	"ar_AE": "Arabski",
	"sk_SK": "Slovakian",
	"de_DE": "Njemački",
	"sr_RS": "Serbian",
	"cs_CZ": "Češki",
	"pl_PL": "Poljski",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Švedski",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Odaberite Jezik",
},
"cs_CZ": {
	"tr_CY": "Turecky",
	"fr_FR": "Francouzsky",
	"fi_FI": "Finsky",
	"pt_PT": "Portugalsky",
	"fy_NL": "Frisian",
	"it_IT": "Italsky",
	"et_EE": "Estonian",
	"nb_NO": "Norsky",
	"nl_NL": "Holandsky",
	"lv_LV": "Latvian",
	"el_GR": "Řecky",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Maďarsky",
	"lt_LT": "Litevsky",
	"sl_SI": "Slovenian",
	"hr_HR": "Chorvatsky",
	"en_GB": "Anglicky",
	"es_ES": "Španělsky",
	"ca_AD": "Katalánsky",
	"ru_RU": "Rusky",
	"is_IS": "Islandsky",
	"da_DK": "Dánsky",
	"ar_AE": "Arabsky",
	"sk_SK": "Slovakian",
	"de_DE": "Německy",
	"sr_RS": "Serbian",
	"cs_CZ": "Česky",
	"pl_PL": "Polsky",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Švédsky",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Výběr jazyka",
},
"da_DK": {
	"tr_CY": "Tyrkisk",
	"fr_FR": "Fransk",
	"fi_FI": "Finsk",
	"pt_PT": "Portugisisk",
	"fy_NL": "Frisisk",
	"it_IT": "Italiensk",
	"et_EE": "Estisk",
	"nb_NO": "Norsk",
	"nl_NL": "Hollandsk",
	"lv_LV": "Lettisk",
	"el_GR": "Græsk",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungarsk",
	"lt_LT": "Litauisk",
	"sl_SI": "Slovensk",
	"hr_HR": "Kroatisk",
	"en_GB": "Engelsk",
	"es_ES": "Spansk",
	"ca_AD": "Katalansk",
	"ru_RU": "Russisk",
	"is_IS": "Islandsk",
	"da_DK": "Dansk",
	"ar_AE": "Arabisk",
	"sk_SK": "Slovakisk",
	"de_DE": "Tysk",
	"sr_RS": "Serbisk",
	"cs_CZ": "Tjekkisk",
	"pl_PL": "Polsk",
	"uk_UA": "Ukrainsk",
	"fa_IR": "Persisk",
	"sv_SE": "Svensk",
	"he_IL": "Hebræisk",
	"T1": "Benyt venligst OP og NED tasten til at vælge sprog. Tryk bagefter på OK knappen.",
	"T2": "Valg af sprog",
},
"nl_NL": {
	"tr_CY": "Turks",
	"fr_FR": "Frans",
	"fi_FI": "Fins",
	"pt_PT": "Portugees",
	"fy_NL": "Fries",
	"it_IT": "Italiaans",
	"et_EE": "Estlands",
	"nb_NO": "Noors",
	"nl_NL": "Nederlands",
	"lv_LV": "Lets",
	"el_GR": "Grieks",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hongaars",
	"lt_LT": "Litouws",
	"sl_SI": "Sloveens",
	"hr_HR": "Kroatisch",
	"en_GB": "Engels",
	"es_ES": "Spaans",
	"ca_AD": "Catalaans",
	"ru_RU": "Russisch",
	"is_IS": "Ijslands",
	"da_DK": "Deens",
	"ar_AE": "Arabisch",
	"sk_SK": "Slowaaks",
	"de_DE": "Duits",
	"sr_RS": "Servisch",
	"cs_CZ": "Tsjechisch",
	"pl_PL": "Pools",
	"uk_UA": "Oekraïens",
	"fa_IR": "Perzisch",
	"sv_SE": "Zweeds",
	"he_IL": "Hebreeuws",
	"T1": "Gebruik de omhoog/omlaag toeten om de gewenste taal te selecteren. Druk daarna op OK.",
	"T2": "Taalkeuze",
},
"et_EE": {
	"tr_CY": "Türgi",
	"fr_FR": "Prantsuse",
	"fi_FI": "Soome",
	"pt_PT": "Portugali",
	"fy_NL": "Friisi",
	"it_IT": "Itaalia",
	"et_EE": "Eesti",
	"nb_NO": "Norra",
	"nl_NL": "Holland",
	"lv_LV": "Läti",
	"el_GR": "Kreeka",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungari",
	"lt_LT": "Leedu",
	"sl_SI": "Sloveenia",
	"hr_HR": "Horvaatia",
	"en_GB": "Inglise",
	"es_ES": "Hispaania",
	"ca_AD": "Katalaani",
	"ru_RU": "Vene",
	"is_IS": "Island",
	"da_DK": "Taani",
	"ar_AE": "Araabia",
	"sk_SK": "Slovakkia",
	"de_DE": "Saksa",
	"sr_RS": "Serbia",
	"cs_CZ": "Tšehhi",
	"pl_PL": "Poola",
	"uk_UA": "Ukraina",
	"fa_IR": "Pärsia",
	"sv_SE": "Rootsi",
	"he_IL": "Hebrew",
	"T1": "Palun kasuta UP ja DOWN nuppe oma keele valimiseks.Keele valimiseks vajuta OK.",
	"T2": "Keele valik",
},
"fi_FI": {
	"tr_CY": "Turkki",
	"fr_FR": "Ranska",
	"fi_FI": "Suomi",
	"pt_PT": "Portugali",
	"fy_NL": "Friisi",
	"it_IT": "Italia",
	"et_EE": "Viro",
	"nb_NO": "Norja",
	"nl_NL": "Hollanti",
	"lv_LV": "Latvia",
	"el_GR": "Kreikka",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Unkari",
	"lt_LT": "Liettua",
	"sl_SI": "Slovenia",
	"hr_HR": "Kroatia",
	"en_GB": "Englanti",
	"es_ES": "Espanja",
	"ca_AD": "Katalaani",
	"ru_RU": "Venäjä",
	"is_IS": "Islanti",
	"da_DK": "Tanska",
	"ar_AE": "Arabia",
	"sk_SK": "Slovakia",
	"de_DE": "Saksa",
	"sr_RS": "Serbia",
	"cs_CZ": "Tšekki",
	"pl_PL": "Puola",
	"uk_UA": "Ukraina",
	"fa_IR": "Persia",
	"sv_SE": "Ruotsi",
	"he_IL": "Hebrea",
	"T1": "Valitse kieli ylös/alas näppäimillä ja paina OK-näppäintä.",
	"T2": "Kielivalinta",
},
"fr_FR": {
	"tr_CY": "Turke",
	"fr_FR": "Français",
	"fi_FI": "Finlandais",
	"pt_PT": "Portugais",
	"fy_NL": "Frison",
	"it_IT": "Italien",
	"et_EE": "Estonien",
	"nb_NO": "Norvégien",
	"nl_NL": "Hollandais",
	"lv_LV": "Letton",
	"el_GR": "Grèque",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hongrois",
	"lt_LT": "Lithuanien",
	"sl_SI": "Slovène",
	"hr_HR": "Croate",
	"en_GB": "Anglais",
	"es_ES": "Espagnol",
	"ca_AD": "Catalan",
	"ru_RU": "Russe",
	"is_IS": "Islandais",
	"da_DK": "Danois",
	"ar_AE": "Arabe",
	"sk_SK": "Slovaque",
	"de_DE": "Allemand",
	"sr_RS": "Serbe",
	"cs_CZ": "Tchèque",
	"pl_PL": "Polonais",
	"uk_UA": "Ukrainien",
	"fa_IR": "Iranien",
	"sv_SE": "Suédois",
	"he_IL": "Hebrew",
	"T1": "Veuillez utiliser les touches HAUT et BAS pour choisir votre langage. Ensuite presser le bouton OK.",
	"T2": "Sélection de la langue",
},
"el_GR": {
	"tr_CY": "Τούρκικα",
	"fr_FR": "Γαλλικά",
	"fi_FI": "Φιλλανδικά",
	"pt_PT": "Πορτογαλλικά",
	"fy_NL": "Frisian",
	"it_IT": "Ιταλικά",
	"et_EE": "Estonian",
	"nb_NO": "Νορβηφικά",
	"nl_NL": "Ολλανδικά",
	"lv_LV": "Latvian",
	"el_GR": "Ελληνικά",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ουγγαρεζικά",
	"lt_LT": "Λιθουανικά",
	"sl_SI": "Slovenian",
	"hr_HR": "Κροάτικα",
	"en_GB": "Αγγλικά",
	"es_ES": "Ισπανικά",
	"ca_AD": "Catalan",
	"ru_RU": "Ρωσικά",
	"is_IS": "Ισλανδικά",
	"da_DK": "Δανικά",
	"ar_AE": "Αραβικά",
	"sk_SK": "Slovakian",
	"de_DE": "Γερμανικά",
	"sr_RS": "Serbian",
	"cs_CZ": "Τσέχικα",
	"pl_PL": "Πολωνικά",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Σουιδεζικά",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Επιλογή γλώσσας",
},
"he_IL": {
	"tr_CY": "טורקית",
	"fr_FR": "צרפתית",
	"fi_FI": "פינית",
	"pt_PT": "פורטוגזית",
	"fy_NL": "Frisian",
	"it_IT": "איטלקית",
	"et_EE": "אסטוניה",
	"nb_NO": "נורווגית",
	"nl_NL": "הולנדית",
	"lv_LV": "Latvian",
	"el_GR": "יוונית",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "הונגרית",
	"lt_LT": "ליטא",
	"sl_SI": "סלובנית",
	"hr_HR": "קרואטית",
	"en_GB": "אנגלית",
	"es_ES": "ספרדית",
	"ca_AD": "קטלוני",
	"ru_RU": "רוסית",
	"is_IS": "איסלנדית",
	"da_DK": "דנית",
	"ar_AE": "ערבית",
	"sk_SK": "סלובקיה",
	"de_DE": "גרמנית",
	"sr_RS": "סרבית",
	"cs_CZ": "צ'כית",
	"pl_PL": "פולנית",
	"uk_UA": "אוקראינית",
	"fa_IR": "Persian",
	"sv_SE": "שוודית",
	"he_IL": "Hebrew",
	"T1": ".אנא בחר את השפה, לאחר מכן לחץ על אשר",
	"T2": "בחירת שפה",
},
"hu_HU": {
	"tr_CY": "Török",
	"fr_FR": "Francia",
	"fi_FI": "Finn",
	"pt_PT": "Portugál",
	"fy_NL": "Fríz",
	"it_IT": "Olasz",
	"et_EE": "Észt",
	"nb_NO": "Norvég",
	"nl_NL": "Holland",
	"lv_LV": "Lett",
	"el_GR": "Görög",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Magyar",
	"lt_LT": "Litván",
	"sl_SI": "Szolvén",
	"hr_HR": "Horvát",
	"en_GB": "Angol",
	"es_ES": "Spanyol",
	"ca_AD": "Katalán",
	"ru_RU": "Orosz",
	"is_IS": "Izlandi",
	"da_DK": "Dán",
	"ar_AE": "Arab",
	"sk_SK": "Szlovák",
	"de_DE": "Német",
	"sr_RS": "Szerb",
	"cs_CZ": "Cseh",
	"pl_PL": "Lengyel",
	"uk_UA": "Ukrán",
	"fa_IR": "Perzsa",
	"sv_SE": "Svéd",
	"he_IL": "Hebrew",
	"T1": "Kérem, használja a FEL és LE gombokat a nyelv kiválasztásához. Ez után nyomja le az OK gombot.",
	"T2": "Nyelvválasztás",
},
"lt_LT": {
	"tr_CY": "Turkų",
	"fr_FR": "Prancūzų",
	"fi_FI": "Suomių",
	"pt_PT": "Portugalų",
	"fy_NL": "Frizų",
	"it_IT": "Italų",
	"et_EE": "Estų",
	"nb_NO": "Norvegų",
	"nl_NL": "Olandų",
	"lv_LV": "Latvių",
	"el_GR": "Graikų",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Vengrų",
	"lt_LT": "Lietuvių",
	"sl_SI": "Slovėnų",
	"hr_HR": "Kroatų",
	"en_GB": "Anglų",
	"es_ES": "Ispanų",
	"ca_AD": "Katalonų",
	"ru_RU": "Rusų",
	"is_IS": "Islandų",
	"da_DK": "Danų",
	"ar_AE": "Arabų",
	"sk_SK": "Slovakų",
	"de_DE": "Vokiečių",
	"sr_RS": "Serbų",
	"cs_CZ": "Čekų",
	"pl_PL": "Lenkų",
	"uk_UA": "Ukrainiečių",
	"fa_IR": "Persų",
	"sv_SE": "Švedų",
	"he_IL": "Hebrajų",
	"T1": "Prašome naudoti AUKŠTYN IR ŽEMYN mygtukus, kad išsirinktumėte savo kalbą. Po to spauskite OK mygtuką.",
	"T2": "Kalbos pasirinkimas",
},
"lv_LV": {
	"tr_CY": "Turku",
	"fr_FR": "Franču",
	"fi_FI": "Somu",
	"pt_PT": "Portugāļu",
	"fy_NL": "Frīzu",
	"it_IT": "Itāļu",
	"et_EE": "Estonian",
	"nb_NO": "Norvēģu",
	"nl_NL": "Holandiešu",
	"lv_LV": "Latviešu",
	"el_GR": "Grieķu",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungāru",
	"lt_LT": "Lietuviešu",
	"sl_SI": "Slovenian",
	"hr_HR": "Horvātu",
	"en_GB": "Angļu",
	"es_ES": "Spāņu",
	"ca_AD": "Katāliešu",
	"ru_RU": "Krievu",
	"is_IS": "Islandiešu",
	"da_DK": "Dāņu",
	"ar_AE": "Arābu",
	"sk_SK": "Slovakian",
	"de_DE": "Vācu",
	"sr_RS": "Serbian",
	"cs_CZ": "Čehu",
	"pl_PL": "Poļu",
	"uk_UA": "Ukraiņu",
	"fa_IR": "Persian",
	"sv_SE": "Zviedru",
	"he_IL": "Hebrew",
	"T1": "Lūdzu lietojiet UP un DOWN taustiņus, lai izvēlētos valodu. Pēc tam spiediet OK.",
	"T2": "Valodas izvēle",
},
"is_IS": {
	"tr_CY": "Tyrkneska",
	"fr_FR": "Franska",
	"fi_FI": "Finnska",
	"pt_PT": "Portúgalska",
	"fy_NL": "Frísneska",
	"it_IT": "Ítalska",
	"et_EE": "Eistneska",
	"nb_NO": "Norska",
	"nl_NL": "Hollenska",
	"lv_LV": "Lettneska",
	"el_GR": "Gríska",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungverska",
	"lt_LT": "Litháíska",
	"sl_SI": "Slovenian",
	"hr_HR": "Króatíska",
	"en_GB": "Enska",
	"es_ES": "Spænska",
	"ca_AD": "Katalónska",
	"ru_RU": "Rússneska",
	"is_IS": "Íslenska",
	"da_DK": "Danska",
	"ar_AE": "Arabíska",
	"sk_SK": "Slovakian",
	"de_DE": "Þýska",
	"sr_RS": "Serneska",
	"cs_CZ": "Tékkneska",
	"pl_PL": "Pólska",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persneska",
	"sv_SE": "Sænskt",
	"he_IL": "Hebrew",
	"T1": "Vinsamlega notið UP og NIÐUR takka til að velja tungumál. Ýttu svo á OK til að nota.",
	"T2": "Val tungumáls",
},
"it_IT": {
	"tr_CY": "Turco",
	"fr_FR": "Francese",
	"fi_FI": "Finlandese",
	"pt_PT": "Portoghese",
	"fy_NL": "Frisone",
	"it_IT": "Italiano",
	"et_EE": "Estone",
	"nb_NO": "Norvegese",
	"nl_NL": "Olandese",
	"lv_LV": "Lettone",
	"el_GR": "Greco",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungherese",
	"lt_LT": "Lituano",
	"sl_SI": "Sloveno",
	"hr_HR": "Croato",
	"en_GB": "Inglese",
	"es_ES": "Spagnolo",
	"ca_AD": "Catalano",
	"ru_RU": "Russo",
	"is_IS": "Islandese",
	"da_DK": "Danese",
	"ar_AE": "Arabo",
	"sk_SK": "Slovacco",
	"de_DE": "Tedesco",
	"sr_RS": "Serbo",
	"cs_CZ": "Ceco",
	"pl_PL": "Polacco",
	"uk_UA": "Ucraino",
	"fa_IR": "Persiano",
	"sv_SE": "Svedese",
	"he_IL": "Ebraico",
	"T1": "Selezionare la propria lingua utilizzando i tasti Sù/Giù. OK >> confermare.",
	"T2": "Selezione lingua",
},
"nb_NO": {
	"tr_CY": "Tyrkisk",
	"fr_FR": "Fransk",
	"fi_FI": "Finsk",
	"pt_PT": "Portugisisk",
	"fy_NL": "Frisisk",
	"it_IT": "Italiensk",
	"et_EE": "Estlandsk",
	"nb_NO": "Norsk",
	"nl_NL": "Nederlandsk",
	"lv_LV": "Latvisk",
	"el_GR": "Gresk",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungarsk",
	"lt_LT": "Litauisk",
	"sl_SI": "Slovenisk",
	"hr_HR": "Kroatisk",
	"en_GB": "Engelsk",
	"es_ES": "Spansk",
	"ca_AD": "Katalansk",
	"ru_RU": "Russisk",
	"is_IS": "Islandsk",
	"da_DK": "Dansk",
	"ar_AE": "Arabisk",
	"sk_SK": "Slovakisk",
	"de_DE": "Tysk",
	"sr_RS": "Serbisk",
	"cs_CZ": "Tjekkisk",
	"pl_PL": "Polsk",
	"uk_UA": "Ukrainsk",
	"fa_IR": "Persisk",
	"sv_SE": "Svensk",
	"he_IL": "Hebraisk",
	"T1": "Vennligst bruk OPP og NED taster for å velge språk. Etterpå trykker du OK tast for å fortsette.",
	"T2": "Språkvalg",
},
"fa_IR": {
	"tr_CY": "ترکی",
	"fr_FR": "فرانسوی",
	"fi_FI": "پایان",
	"pt_PT": "پرتغالی",
	"fy_NL": "فریزی",
	"it_IT": "ایتالیایی",
	"et_EE": "استونیایی",
	"nb_NO": "نروژی",
	"nl_NL": "فلمنکی",
	"lv_LV": "لتونی",
	"el_GR": "یونانی",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "مجارستانی",
	"lt_LT": "لیتوانی",
	"sl_SI": "اسلوونیایی",
	"hr_HR": "کرواسی",
	"en_GB": "انگلیسی",
	"es_ES": "اسپانیایی",
	"ca_AD": "کاتالان",
	"ru_RU": "روسی",
	"is_IS": "ایسلندی",
	"da_DK": "دانمارکی",
	"ar_AE": "عربی",
	"sk_SK": "اسلواکی",
	"de_DE": "آلمانی",
	"sr_RS": "صربستانی",
	"cs_CZ": "چکوسلواکی",
	"pl_PL": "لهستانی",
	"uk_UA": "اوکراینی",
	"fa_IR": "فارسی",
	"sv_SE": "سوئدی",
	"he_IL": "عبری",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "انتخاب زبان",
},
"pl_PL": {
	"tr_CY": "Turecki",
	"fr_FR": "Francuski",
	"fi_FI": "Fiński",
	"pt_PT": "Portugalski",
	"fy_NL": "Fryzyjski",
	"it_IT": "Włoski",
	"et_EE": "Estoński",
	"nb_NO": "Norweski",
	"nl_NL": "Holenderski",
	"lv_LV": "Łotewski",
	"el_GR": "Grecki",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Węgierski",
	"lt_LT": "Litewski",
	"sl_SI": "Słoweński",
	"hr_HR": "Chorwacki",
	"en_GB": "Angielski",
	"es_ES": "Hiszpański",
	"ca_AD": "Hiszpański",
	"ru_RU": "Rosyjski",
	"is_IS": "Islandzki",
	"da_DK": "Duński",
	"ar_AE": "Arabski",
	"sk_SK": "Słowacki",
	"de_DE": "Niemiecki",
	"sr_RS": "Serbski",
	"cs_CZ": "Czeski",
	"pl_PL": "Polski",
	"uk_UA": "Ukraiński",
	"fa_IR": "Perski",
	"sv_SE": "Szwedzki",
	"he_IL": "Hebrajski",
	"T1": "W celu wyboru języka użyj klawiszy GÓRA i DÓŁ. Nastepnie nacisnij przycisk OK.",
	"T2": "Wybór języka",
},
"pt_PT": {
	"tr_CY": "Turco",
	"fr_FR": "Francês",
	"fi_FI": "Finlandês",
	"pt_PT": "Português",
	"fy_NL": "Frisian",
	"it_IT": "Italiano",
	"et_EE": "Estonian",
	"nb_NO": "Norueguês",
	"nl_NL": "Holandês",
	"lv_LV": "Latvian",
	"el_GR": "Grego",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hungaro",
	"lt_LT": "Lituano",
	"sl_SI": "Slovenian",
	"hr_HR": "Croata",
	"en_GB": "Inglês",
	"es_ES": "Catalão",
	"ca_AD": "Catalão",
	"ru_RU": "Russo",
	"is_IS": "Islandês",
	"da_DK": "Dinamarquês",
	"ar_AE": "Arabe",
	"sk_SK": "Slovakian",
	"de_DE": "Alemão",
	"sr_RS": "Serbian",
	"cs_CZ": "Checo",
	"pl_PL": "Polaco",
	"uk_UA": "Ukrainian",
	"fa_IR": "Persian",
	"sv_SE": "Sueco",
	"he_IL": "Hebrew",
	"T1": "Please use the UP and DOWN keys to select your language. Afterwards press the OK button.",
	"T2": "Selecção do Idioma",
},
"ru_RU": {
	"tr_CY": "Турецкий",
	"fr_FR": "Французский",
	"fi_FI": "Финский",
	"pt_PT": "Португальский",
	"fy_NL": "Фризский",
	"it_IT": "Итальянский",
	"et_EE": "Estonian",
	"nb_NO": "Норвежский",
	"nl_NL": "Нидерландский",
	"lv_LV": "Латвийский",
	"el_GR": "Греческий",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Венгерский",
	"lt_LT": "Литовский",
	"sl_SI": "Slovenian",
	"hr_HR": "Хорватский",
	"en_GB": "Английский",
	"es_ES": "Испанский",
	"ca_AD": "Каталонский",
	"ru_RU": "Русский",
	"is_IS": "Исландский",
	"da_DK": "Датский",
	"ar_AE": "Арабский",
	"sk_SK": "Slovakian",
	"de_DE": "Немецкий",
	"sr_RS": "Serbian",
	"cs_CZ": "Чешский",
	"pl_PL": "Польский",
	"uk_UA": "Украинский",
	"fa_IR": "Persian",
	"sv_SE": "Шведский",
	"he_IL": "Hebrew",
	"T1": "Пожалуйста, используйте кнопки ВВЕРХ и ВНИЗ для выбора языка. Далее нажмите ОК.",
	"T2": "Выбор языка",
},
"sr_RS": {
	"tr_CY": "Turski",
	"fr_FR": "Francuski",
	"fi_FI": "Finski",
	"pt_PT": "Portugalski",
	"fy_NL": "Frizijski",
	"it_IT": "Italijanski",
	"et_EE": "Estonski",
	"nb_NO": "Norveški",
	"nl_NL": "Holandski",
	"lv_LV": "Letonski",
	"el_GR": "Grčki",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Mađarski",
	"lt_LT": "Litvanski",
	"sl_SI": "Slovenački",
	"hr_HR": "Hrvatski",
	"en_GB": "Engleski",
	"es_ES": "Španski",
	"ca_AD": "Katalonski",
	"ru_RU": "Ruski",
	"is_IS": "Islandski",
	"da_DK": "Danski",
	"ar_AE": "Arapski",
	"sk_SK": "Slovački",
	"de_DE": "Nemački",
	"sr_RS": "Srpski",
	"cs_CZ": "Češki",
	"pl_PL": "Poljski",
	"uk_UA": "Ukrajinski",
	"fa_IR": "Persijski",
	"sv_SE": "Švedski",
	"he_IL": "Hebrew",
	"T1": "Molim koristite UP i DOWN tipke da izaberete jezik.Posle toga pritisnite OK dugme.",
	"T2": "Izbor jezika",
},
"sk_SK": {
	"tr_CY": "Turečtina",
	"fr_FR": "Francúzština",
	"fi_FI": "Fínčina",
	"pt_PT": "Portugalčina",
	"fy_NL": "Frízština",
	"it_IT": "Taliančina",
	"et_EE": "Estónčina",
	"nb_NO": "Nórčina",
	"nl_NL": "Holandčina",
	"lv_LV": "Lotyščina",
	"el_GR": "Gréčtina",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Maďarčina",
	"lt_LT": "Litovčina",
	"sl_SI": "Slovinčina",
	"hr_HR": "Chorvátčina",
	"en_GB": "Angličtina",
	"es_ES": "Španielčina",
	"ca_AD": "Katalánčina",
	"ru_RU": "Ruština",
	"is_IS": "Islandčina",
	"da_DK": "Dánčina",
	"ar_AE": "Arabčina",
	"sk_SK": "Slovenčina",
	"de_DE": "Nemčina",
	"sr_RS": "Srbčina",
	"cs_CZ": "Čeština",
	"pl_PL": "Poľština",
	"uk_UA": "Ukrajinčina",
	"fa_IR": "Perzština",
	"sv_SE": "Švédčina",
	"he_IL": "Hebrejčina",
	"T1": "Tlačidlami NAHOR alebo NADOL zvoľte jazyk. Potom stlačte tlačidlo OK.",
	"T2": "Voľba jazyka",
},
"sl_SI": {
	"tr_CY": "Turško",
	"fr_FR": "Francosko",
	"fi_FI": "Finsko",
	"pt_PT": "Portugalsko",
	"fy_NL": "Frisian",
	"it_IT": "Italjansko",
	"et_EE": "Estonian",
	"nb_NO": "Norveški",
	"nl_NL": "Nizozemsko",
	"lv_LV": "Latvian",
	"el_GR": "Grško",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Madžarsko",
	"lt_LT": "Litvansko",
	"sl_SI": "Slovensko",
	"hr_HR": "Hrvaško",
	"en_GB": "Angleško",
	"es_ES": "Špansko",
	"ca_AD": "Katalonski",
	"ru_RU": "Rusko",
	"is_IS": "Islandsko",
	"da_DK": "Dansko",
	"ar_AE": "Arabsko",
	"sk_SK": "Slovakian",
	"de_DE": "Nemško",
	"sr_RS": "Serbian",
	"cs_CZ": "Češko",
	"pl_PL": "Poljsko",
	"uk_UA": "Ukrajinsko",
	"fa_IR": "Persian",
	"sv_SE": "Švedsko",
	"he_IL": "Hebrew",
	"T1": "Prosim uporabite tipke GOR in DOL za izbiro jezika in pritisnite OK tipko za potrditev.",
	"T2": "Izberite jezik",
},
"es_ES": {
	"tr_CY": "Turco",
	"fr_FR": "Francés",
	"fi_FI": "Finlandés",
	"pt_PT": "Portugués",
	"fy_NL": "Frisón",
	"it_IT": "Italiano",
	"et_EE": "Estonio",
	"nb_NO": "Noruego",
	"nl_NL": "Alemán",
	"lv_LV": "Letón",
	"el_GR": "Griego",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Húngaro",
	"lt_LT": "Lituano",
	"sl_SI": "Esloveno",
	"hr_HR": "Croata",
	"en_GB": "Inglés",
	"es_ES": "Español",
	"ca_AD": "Catalán",
	"ru_RU": "Ruso",
	"is_IS": "Islandés",
	"da_DK": "Danés",
	"ar_AE": "Arábigo",
	"sk_SK": "Eslovaco",
	"de_DE": "Alemán",
	"sr_RS": "Servio",
	"cs_CZ": "Checo",
	"pl_PL": "Polaco",
	"uk_UA": "Ucraniano",
	"fa_IR": "Persa",
	"sv_SE": "Sueco",
	"he_IL": "Hebrew",
	"T1": "Use las teclas ARRIBA y ABAJO para seleccionar su idioma. Después, pulse el botón OK.",
	"T2": "Selección de idioma",
},
"sv_SE": {
	"tr_CY": "Turkiska",
	"fr_FR": "Franska",
	"fi_FI": "Finska",
	"pt_PT": "Portugisiska",
	"fy_NL": "Frisiska",
	"it_IT": "Italienska",
	"et_EE": "Estniska",
	"nb_NO": "Norska",
	"nl_NL": "Holländska",
	"lv_LV": "Lettiska",
	"el_GR": "Grekiska",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Ungerska",
	"lt_LT": "Litauiska",
	"sl_SI": "Slovenska",
	"hr_HR": "Kroatiska",
	"en_GB": "Engelska",
	"es_ES": "Spanska",
	"ca_AD": "Katalanska",
	"ru_RU": "Ryska",
	"is_IS": "Isländska",
	"da_DK": "Danska",
	"ar_AE": "Arabiska",
	"sk_SK": "Slovakisk",
	"de_DE": "Tyska",
	"sr_RS": "Serbiska",
	"cs_CZ": "Tjeckiska",
	"pl_PL": "Polska",
	"uk_UA": "Ukrainska",
	"fa_IR": "Persiska",
	"sv_SE": "Svenska",
	"he_IL": "Hebreiska",
	"T1": "Vänligen använd UPP och NER pil för att välja språk. Efter val tryck på OK knappen.",
	"T2": "Välj språk",
},
"tr_CY": {
	"tr_CY": "Türkçe",
	"fr_FR": "Fransızca",
	"fi_FI": "Fince",
	"pt_PT": "Portekizce",
	"fy_NL": "Frizyece",
	"it_IT": "İtalyanca",
	"et_EE": "Estçe",
	"nb_NO": "Norveççe",
	"nl_NL": "Flemenkçe",
	"lv_LV": "Letonca",
	"el_GR": "Yunanca",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Macarca",
	"lt_LT": "Litvanyaca",
	"sl_SI": "Slovence",
	"hr_HR": "Hırvatça",
	"en_GB": "İngilizce",
	"es_ES": "İspanyolca",
	"ca_AD": "Katalanca",
	"ru_RU": "Rusça",
	"is_IS": "İzlandaca",
	"da_DK": "Danca",
	"ar_AE": "Arapça",
	"sk_SK": "Slovakça",
	"de_DE": "Almanca",
	"sr_RS": "Sırpça",
	"cs_CZ": "Çekçe",
	"pl_PL": "Lehçe",
	"uk_UA": "Ukraynaca",
	"fa_IR": "Farsça",
	"sv_SE": "İsveççe",
	"he_IL": "Hebrew",
	"T1": "Dil seçiminizi, yapmak için YUKARI ve AŞAĞI tuşlarını, onaylamak için OK tuşunu kullanın.",
	"T2": "Dil seçimi",
},
"uk_UA": {
	"tr_CY": "Турецька",
	"fr_FR": "Французька",
	"fi_FI": "Фінська",
	"pt_PT": "Португальська",
	"fy_NL": "Фрізійська",
	"it_IT": "Італійська",
	"et_EE": "Estonian",
	"nb_NO": "Норвежська",
	"nl_NL": "Голландська",
	"lv_LV": "Латвійська",
	"el_GR": "Грецька",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Угорська",
	"lt_LT": "Литовська",
	"sl_SI": "Slovenian",
	"hr_HR": "Хорватьска",
	"en_GB": "Англійська",
	"es_ES": "Іспанська",
	"ca_AD": "Каталонська",
	"ru_RU": "Російська",
	"is_IS": "Ісландська",
	"da_DK": "Данська",
	"ar_AE": "Арабський",
	"sk_SK": "Slovakian",
	"de_DE": "Німецька",
	"sr_RS": "Сербська",
	"cs_CZ": "Чешська",
	"pl_PL": "Польська",
	"uk_UA": "Українська",
	"fa_IR": "Persian",
	"sv_SE": "Шведська",
	"he_IL": "Hebrew",
	"T1": "Використовуйте кнопки ВВЕРХ і ВНИЗ, щоб вибрати Вашу мову. Після вибору натисніть OK.",
	"T2": "Вибір мови",
},
"fy_NL": {
	"tr_CY": "Turksk",
	"fr_FR": "Frânsk",
	"fi_FI": "Finsk",
	"pt_PT": "Portugeesk",
	"fy_NL": "Frysk ",
	"it_IT": "Italiaansk",
	"et_EE": "Estonian",
	"nb_NO": "Noarsk",
	"nl_NL": "Nederlansk",
	"lv_LV": "Latvian",
	"el_GR": "Gryks",
	"pt_BR": "Brazilian Portuguese",
	"hu_HU": "Hongaarsk",
	"lt_LT": "Lithuaniansk",
	"sl_SI": "Slovenian",
	"hr_HR": "Kroatysk",
	"en_GB": "Engelsk",
	"es_ES": "Spaans",
	"ca_AD": "Catalânsk",
	"ru_RU": "Russysk",
	"is_IS": "Iislansk",
	"da_DK": "Deensk",
	"ar_AE": "Arabysk",
	"sk_SK": "Slovakian",
	"de_DE": "Dúts",
	"sr_RS": "Serbian",
	"cs_CZ": "Tsjechysk",
	"pl_PL": "Poolsk",
	"uk_UA": "Oekraïne",
	"fa_IR": "Persian",
	"sv_SE": "Zweeds",
	"he_IL": "Hebrew",
	"T1": "Brúk de op en del toets om jo taal te kiezen. Dernei druk op OK",
	"T2": "Taal Kieze",
},
}
