from Tools.LoadPixmap import LoadPixmap
from Components.Pixmap import Pixmap
from Renderer import Renderer
from enigma import ePixmap
from enigma import eServiceReference, eServiceCenter
from Tools.Directories import fileExists, SCOPE_SKIN_IMAGE, SCOPE_CURRENT_SKIN, resolveFilename
from Components.config import *

class MetrixXPicon(Renderer):
	searchPaths = (	'/media/hdd/XPicons/%s/',
					'/media/usb/XPicons/%s/',
					'/media/usb1/XPicons/%s/',
					'/media/card/XPicons/%s/',
					'/media/cf/XPicons/%s/',
					'/usr/share/enigma2/XPicons/%s/' ) 

	def __init__(self):
		Renderer.__init__(self)

		self.path = "picon"
		self.nameCache = { }
		self.pngname = "" 
		
	def applySkin(self, desktop, parent):
		attribs = [ ]
		for (attrib, value) in self.skinAttributes:
			if attrib == "path":
				self.path = value
			else:
				attribs.append((attrib,value))
		self.skinAttributes = attribs
		return Renderer.applySkin(self, desktop, parent)
		
	GUI_WIDGET = ePixmap

	def changed(self, what):
		if self.instance:
			if what[0] != self.CHANGED_CLEAR:
				pngname = self.findPiconName(what)
				if self.pngname != pngname:
					self.pngname = pngname
				self.instance.setPixmapFromFile(self.pngname)

	def findPiconName(self, what):
		pngname = ""
		sname = self.source.text
		if sname is not None and sname != "":
			tmp = self.alternative(sname).split(':', 10)[:10]
			if len(tmp) > 0 and tmp[0] == '4097':
				tmp[0] = '1'
			sname = '_'.join(tmp)
			pngname = self.nameCache.get(sname, "")
			if pngname == "":
				pngname = self.findPicon(sname)
				if pngname != "":
					self.nameCache[sname] = pngname 
		if pngname == "":
			pngname = self.nameCache.get("default", "")
			if pngname == "":
				pngname = self.findPicon("picon_default")
				if pngname == "":
					tmp = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
					if fileExists(tmp):
						pngname = tmp
					else:
						pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
				self.nameCache["default"] = pngname
		return pngname 

	def alternative(self, serviceName):
		def alternativeChannels(service):
			tmp = eServiceCenter.getInstance().list(eServiceReference(service))
			return tmp and tmp.getContent("S", True)
		if serviceName.startswith('1:134:'):
			channels = alternativeChannels(serviceName)
			if channels:
				return channels[0]
		return serviceName

	def findPicon(self, serviceName):
		for path in self.searchPaths:
			pngname = (path % self.path) + serviceName + ".png"
			if fileExists(pngname):
				return pngname
		return ""