from Tools.Directories import resolveFilename, SCOPE_SYSETC
from enigma import getEnigmaVersionString
from Tools.IO import runPipe

class About:
	def __init__(self):
		pass

	def getVersionString(self):
		return self.getImageVersionString()

	def getImageVersionString(self):
		try:
			file = open(resolveFilename(SCOPE_SYSETC, 'satlodge-version'), 'r')
			lines = file.readlines()
			for x in lines:
				splitted = x.split('=')
				if splitted[0] == "version":
					version = splitted[1].strip('\n')
				elif splitted[0] == "date":
					#     YYYY MM DD hh mm
					#0120 2005 11 29 01 16
					#0123 4567 89 01 23 45
					year = splitted[1][0:4]
					month = splitted[1][4:6]
					day = splitted[1][6:8]
					date = '-'.join((day, month, year))
				elif splitted[0] == "distro name":
					distroname = splitted[1].strip('\n')
				elif splitted[0] == "creator":
					creator = "(%s)" % splitted[1].strip('\n')
			print ' '.join((distroname, version, date, creator))
			return ' '.join((distroname, version, date, creator))
			file.close()
		except IOError:
			pass

		return "unavailable"

	def getImageVersionString_DMM(self):
		try:
			file = open(resolveFilename(SCOPE_SYSETC, 'image-version'), 'r')
			lines = file.readlines()
			for x in lines:
				splitted = x.split('=')
				if splitted[0] == "version":
					#     YYYY MM DD hh mm
					#0120 2005 11 29 01 16
					#0123 4567 89 01 23 45
					version = splitted[1]
					image_type = version[0] # 0 = release, 1 = experimental
					major = version[1]
					minor = version[2]
					revision = version[3]
					year = version[4:8]
					month = version[8:10]
					day = version[10:12]
					date = '-'.join((year, month, day))
					if image_type == '0':
						image_type = "Release"
					else:
						image_type = "Experimental"
					version = '.'.join((major, minor, revision))
					if version != '0.0.0':
						return ' '.join((image_type, version, date))
					else:
						return ' '.join((image_type, date))
			file.close()
		except IOError:
			pass

		return "unavailable"

	def getEnigmaVersionString(self):
		return getEnigmaVersionString()

	def getKernelVersionString(self):
		try:
			_, output = runPipe(['uname', '-r'])
			return output.split('-')[0]
		except:
			pass

		return "unknown"

about = About()
