#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from urllib.parse import quote
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings
from json import dumps
from time import localtime, strftime, mktime
from Plugins.Extensions.OpenWebif.controllers.views.ajax.renderevtblock import renderEvtBlock

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.4.0'
__CHEETAH_versionTuple__ = (3, 4, 0, 'final', 0)
__CHEETAH_genTime__ = 1755702592.9098122
__CHEETAH_genTimestamp__ = 'Wed Aug 20 15:09:52 2025'
__CHEETAH_src__ = '/mnt/66db6310-ef67-48e5-833d-28a4e8403d9f/satlodge-dream/build/tmp/work/dm920-oe-linux-gnueabi/enigma2-plugin-extensions-openwebif/git/sources/enigma2-plugin-extensions-openwebif-git/plugin/controllers/views/ajax/multiepg.tmpl'
__CHEETAH_srcLastModified__ = 'Wed Aug 20 13:53:06 2025'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class multiepg(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(multiepg, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<style>
\ttable { font-family: Verdana; font-size: 11px; }
\ttr { vertical-align: top }
\t.float { float:left }
\t.service { font-weight: bold; font-size: 12px; line-height:30px; padding-right: 4px; white-space: nowrap; overflow: hidden;}
\t.service img { width:50px; height:30px; float:left; margin-right:10px; border: 0;}
\t.title { font-weight: bold;}
\t.desc { font-size: 10px; line-height: 1.25em; max-height: 3.75em; overflow: hidden; }
\t.event { cursor: pointer; width: 190px; overflow:hidden; margin-bottom: 0.75em;}
\t.bq { font-size: 11px; font-weight: bold; padding: 2px 4px; line-height: 18px; cursor: pointer; white-space: nowrap; display: inline-block; margin: 1px 1px 0px 0px;}
\t.plus { font-size: 13px; font-weight: bold; padding: 2px 4px; line-height: 21px; cursor: pointer; white-space: nowrap; }
\t.timer { font-weight: bold; font-size: 10px; }
\t#eventdescription { width: 375px; height: auto; position: fixed; top: 205px; left: 350px; z-index: 100; display: none; overflow: auto; }
\t#navepg { margin-bottom: 1px; }
\t#tbl1 thead tr, #tbl1 tfoot tr { display: block; width: 100%; }
\t#tbl1 tbody { width: 100%; height: 100%; overflow-y: auto; display: block; overflow-x: hidden;}
\t.ui-widget-content.nobg , .ui-widget-header.nobg{ background-image: none; } 
\t.wrapper { overflow-x: auto; width: 100%; -ms-overflow-style: -ms-autohiding-scrollbar;}
\ttd.border { width: 190px; }
\t.plus.ui-state-default.lbl { border:none; background:none; cursor:default; color:inherit;}
\t.wrapper::-webkit-scrollbar { width: 12px; }
\t#tblinner::-webkit-scrollbar { width: 8px; }
\t::-webkit-scrollbar-track { background: #f1f1f1; }
\t::-webkit-scrollbar-thumb { background: #6784b3; }
</style>

<div id="navepg">
''')
        for slot in list(range(0,7)): # generated from line 33, col 1
            write('''\t<div class="float plus ui-state-default ''')
            if VFFSL(SL,"slot",True)==VFFSL(SL,"day",True) : # generated from line 34, col 42
                _v =  'ui-state-active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  '' 
                if _v is not None: write(_filter(_v))
            write('''" data-day="''')
            _v = VFFSL(SL,"slot",True) # '$(slot)' on line 34, col 102
            if _v is not None: write(_filter(_v, rawExpr='$(slot)')) # from line 34, col 102.
            write('''">''')
            _v = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))] # '$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]' on line 34, col 111
            if _v is not None: write(_filter(_v, rawExpr='$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]')) # from line 34, col 111.
            write('''</div>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 36, col 1
            write('''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['prime_times'] # "$tstrings['prime_times']" on line 37, col 52
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['prime_times']")) # from line 37, col 52.
            write(''':&nbsp;</div>
<div id="pt0" class="float plus ui-state-default" data-day="201">06:00</div>
<div id="pt1" class="float plus ui-state-default" data-day="202">12:00</div>
<div id="pt2" class="float plus ui-state-default" data-day="203">20:00</div>
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 41, col 1
                write('''<div id="pt3" class="float">&nbsp;</div>
<div id="pt4" class="float plus ui-state-default" data-day="200">''')
                _v = VFFSL(SL,"tstrings",True)['now'] # "$tstrings['now']" on line 43, col 66
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['now']")) # from line 43, col 66.
                write('''</div>
''')
        else: # generated from line 45, col 1
            write('''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['cw'] # "$tstrings['cw']" on line 46, col 52
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['cw']")) # from line 46, col 52.
            write(''':&nbsp;</div>
''')
            for wk in list(range(0,3)): # generated from line 47, col 1
                w = VFFSL(SL,"wk",True) + 1000
                write('''\t<div class="float plus ui-state-default ''')
                if VFFSL(SL,"wk",True)==VFFSL(SL,"week",True) : # generated from line 49, col 42
                    _v =  'ui-state-active' 
                    if _v is not None: write(_filter(_v))
                else:
                    _v =  '' 
                    if _v is not None: write(_filter(_v))
                write('''" data-day="''')
                _v = VFFSL(SL,"w",True) # '$(w)' on line 49, col 101
                if _v is not None: write(_filter(_v, rawExpr='$(w)')) # from line 49, col 101.
                write('''">''')
                _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%V",time.localtime(time.time()+604800*wk)) # '$time.strftime("%V",time.localtime(time.time()+604800*wk))' on line 49, col 107
                if _v is not None: write(_filter(_v, rawExpr='$time.strftime("%V",time.localtime(time.time()+604800*wk))')) # from line 49, col 107.
                write('''</div>
''')
        write('''<div class="float plus ui-state-default lbl">&nbsp;''')
        _v = VFFSL(SL,"tstrings",True)['display_mode'] # "$tstrings['display_mode']" on line 52, col 52
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['display_mode']")) # from line 52, col 52.
        write(''':&nbsp;</div>
<div class="float plus ui-state-default ''')
        if VFFSL(SL,"mode",True)==1 : # generated from line 53, col 41
            _v =  'ui-state-active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  '' 
            if _v is not None: write(_filter(_v))
        write('''" data-day="101">''')
        _v = VFFSL(SL,"tstrings",True)['tv_guide'] # "$tstrings['tv_guide']" on line 53, col 103
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['tv_guide']")) # from line 53, col 103.
        write('''</div>
<div class="float plus ui-state-default ''')
        if VFFSL(SL,"mode",True)==2 : # generated from line 54, col 41
            _v =  'ui-state-active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  '' 
            if _v is not None: write(_filter(_v))
        write('''" data-day="102">''')
        _v = VFFSL(SL,"tstrings",True)['timeline'] # "$tstrings['timeline']" on line 54, col 103
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['timeline']")) # from line 54, col 103.
        write('''</div>
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 55, col 1
            write('''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['date'] # "$tstrings['date']" on line 56, col 52
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['date']")) # from line 56, col 52.
            write(''':&nbsp;''')
            _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%x", time.localtime(time.time()+86400*VFFSL(SL,"day",True)+604800*VFFSL(SL,"week",True))) # '$time.strftime("%x", time.localtime(time.time()+86400*$day+604800*$week))' on line 56, col 76
            if _v is not None: write(_filter(_v, rawExpr='$time.strftime("%x", time.localtime(time.time()+86400*$day+604800*$week))')) # from line 56, col 76.
            write('''</div>
''')
        write('''<div id="compressmepg" onclick="CompressMEPG();"><i id="compressmepgi" class="fa fa-compress link" aria-hidden="true"></i></div>
<div id="refreshmepg2" onclick="RefreshMEPG();"><i id="refreshmepgi" class="fa fa-refresh link" aria-hidden="true"></i></div>
\t<br clear="all">

''')
        for bq in VFFSL(SL,"bouquets",True): # generated from line 62, col 1
            write('''\t<div class="float bq ui-state-default ''')
            if VFFSL(SL,"bq",True)[0]==VFFSL(SL,"bref",True) : # generated from line 63, col 40
                _v =  'ui-state-active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  '' 
                if _v is not None: write(_filter(_v))
            write('''" data-ref="''')
            _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bq",True)[0]) # '$quote($bq[0])' on line 63, col 102
            if _v is not None: write(_filter(_v, rawExpr='$quote($bq[0])')) # from line 63, col 102.
            write('''">''')
            _v = VFFSL(SL,"bq",True)[1] # '$bq[1]' on line 63, col 118
            if _v is not None: write(_filter(_v, rawExpr='$bq[1]')) # from line 63, col 118.
            write('''</div>
''')
        write('''<br clear="all">
</div>

''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 68, col 1
            write('''
<style>
.picon { display: inline-block; margin:0; max-width: 100px;}
.picon > img { max-height: 30px;}

.eventlist { display: inline-block; list-style-type: none; margin: 0px; padding: 1px 0px; width: calc(100% - 105px); }
.event { display: block; position: relative; vertical-align: top; clear: left; border: none; }
.event a,.event > span { padding: 0 0 0 10px; height:48px; width:100%; display: block; white-space: normal; overflow: hidden; }
.event a:link:hover { text-decoration: none; }
.ename { display: block; width: 100%; float: left; font-weight: 200; line-height: 1,4; font-size: 14px; }
.etime,.etimer  { display: inline-block; padding-right: 20px; font-weight: 200; line-height: 1,4; font-size: 12px; }
.event { display: inline-block; border-width: 0px 0px 0px 1px; }
.event .ename,.event .etime,.event .etimer { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
</style>

''')
            now = VFFSL(SL,"mktime",False)(VFFSL(SL,"localtime",False)())
            write('''
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 86, col 1
                first = VFFSL(SL,"now",True) - 3600
            else: # generated from line 88, col 1
                first = VFFSL(SL,"now",True) + (VFFSL(SL,"day",True) * 3600 * 24)
            write('''
''')
            s = VFFSL(SL,"strftime",False)("%S",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            m = VFFSL(SL,"strftime",False)("%M",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            offset = VFFSL(SL,"int",False)(VFFSL(SL,"m",True)) * 60
            offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"s",True))
            write('''
''')
            if VFFSL(SL,"day",True) > 0: # generated from line 97, col 1
                h = VFFSL(SL,"strftime",False)("%H",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
                offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"h",True)) * 60 * 60
                offset = VFFSL(SL,"offset",True) + 3600
            write('''
''')
            first = VFFSL(SL,"first",True) - VFFSL(SL,"offset",True)
            write('''
''')
        write('''
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 107, col 1
            renderEventBlock = VFFSL(SL,"renderEvtBlock",False)()
            write('''<div class="wrapper">
<table border="0" cellpadding="0" cellspacing="0" width="100%" id="tbl1">
<thead>
<tr>
''')
            for sname, eventlist in VFN(VFFSL(SL,"events",True),"items",False)(): # generated from line 113, col 2
                evl = VFFSL(SL,"eventlist",True)[0]
                ref = ""
                if VFFSL(SL,"evl",True): # generated from line 116, col 2
                    ev = VFFSL(SL,"evl",True)[0]
                    ref = "data-ref='" + VFFSL(SL,"ev.ref",True) + "'"
                write('''\t<td class="border"><div class="service ui-widget-header" ''')
                _v = VFFSL(SL,"ref",True) # '$ref' on line 120, col 59
                if _v is not None: write(_filter(_v, rawExpr='$ref')) # from line 120, col 59.
                write('''><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # '$(picons[$sname])' on line 120, col 74
                if _v is not None: write(_filter(_v, rawExpr='$(picons[$sname])')) # from line 120, col 74.
                write('''" /> ''')
                _v = VFFSL(SL,"sname",True) # '$sname' on line 120, col 96
                if _v is not None: write(_filter(_v, rawExpr='$sname')) # from line 120, col 96.
                write('''</div></td>
''')
            write('''</tr>
</thead>
<tbody id="tbl1body">
''')
            for slot in list(range(0,12)): # generated from line 125, col 2
                write('''\t<tr class="''')
                _v = VFFSL(SL,"slot",True)%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover' # "$(slot%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover')" on line 126, col 13
                if _v is not None: write(_filter(_v, rawExpr="$(slot%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover')")) # from line 126, col 13.
                write(''' nobg">
''')
                for sname, eventlist in VFN(VFFSL(SL,"events",True),"items",False)(): # generated from line 127, col 3
                    write('''\t\t<td class="border">
''')
                    for event in VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]: # generated from line 129, col 4
                        write('''\t\t\t\t''')
                        _v = VFN(VFFSL(SL,"renderEventBlock",True),"render",False)(VFFSL(SL,"event",True)) # '$renderEventBlock.render($event)' on line 130, col 5
                        if _v is not None: write(_filter(_v, rawExpr='$renderEventBlock.render($event)')) # from line 130, col 5.
                        write('''
''')
                    if len(VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]) == 0: # generated from line 132, col 4
                        write('''\t\t\t<div class="event"></div>
''')
                    write('''\t\t</td>
''')
                write('''\t</tr>
''')
            write('''</tbody>
<tfoot>
<tr>
''')
            for sname, eventlist in VFN(VFFSL(SL,"events",True),"items",False)(): # generated from line 142, col 2
                write('''\t<td class="border"><div class="service ui-widget-header"><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # '$(picons[$sname])' on line 143, col 69
                if _v is not None: write(_filter(_v, rawExpr='$(picons[$sname])')) # from line 143, col 69.
                write('''" /> ''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 143, col 91
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 143, col 91.
                write('''</div></td>
''')
            write('''</tr>
</tfoot>
</table>
''')
        else: # generated from line 148, col 1
            write('''<div class="wrapper">
<div id="tbl1body" style="position: relative; width: 100%;">
\t<div id="tblinner" style="height: auto;width: 100%; white-space: nowrap;">
\t<div class="timetable">
\t<div>
\t<div class="timetable-now"></div>
\t</div>
\t</div>

\t<ol id="timescroller" class="channel-listing ui-widget-header nobg" style="border:none;">
\t\t<li>
\t\t\t<span>
\t\t\t\t<div class="togglescroll ui-widget-header">
\t\t\t\t\t<h2 class="picon" ></h2>
\t\t\t\t\t<span></span>
\t\t\t\t</div>
\t\t\t</span>
\t\t\t<ol cass="eventlist">
''')
            pad = 141
            write('''\t\t\t\t<li class="event" style="width:''')
            _v = VFFSL(SL,"pad",True) # '${pad}' on line 168, col 36
            if _v is not None: write(_filter(_v, rawExpr='${pad}')) # from line 168, col 36.
            write('''px;">
\t\t\t\t</li>
''')
            for slot in list(range(0,50)): # generated from line 170, col 5
                t = VFFSL(SL,"first",True) + (VFFSL(SL,"slot",True) * 3600)
                write('''\t\t\t\t\t<li class="event" style="width:600px;" data-dt="''')
                _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # '$strftime("%H:%M", $localtime($t))' on line 172, col 54
                if _v is not None: write(_filter(_v, rawExpr='$strftime("%H:%M", $localtime($t))')) # from line 172, col 54.
                write('''">
\t\t\t\t\t\t<span class="ui-widget-header nobg">
\t\t\t\t\t\t\t<span class="ename">''')
                _v = VFFSL(SL,"tstrings",True)[("day_" + (VFFSL(SL,"strftime",False)("%w",VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True)))))] # '$tstrings[("day_" + ($strftime("%w",$localtime($t))))]' on line 174, col 28
                if _v is not None: write(_filter(_v, rawExpr='$tstrings[("day_" + ($strftime("%w",$localtime($t))))]')) # from line 174, col 28.
                write(''', ''')
                _v = VFFSL(SL,"strftime",False)('%d.%m.', VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # "$strftime('%d.%m.', $localtime($t))" on line 174, col 84
                if _v is not None: write(_filter(_v, rawExpr="$strftime('%d.%m.', $localtime($t))")) # from line 174, col 84.
                write('''</span>
\t\t\t\t\t\t\t<span class="etime">''')
                _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # '$strftime("%H:%M", $localtime($t))' on line 175, col 28
                if _v is not None: write(_filter(_v, rawExpr='$strftime("%H:%M", $localtime($t))')) # from line 175, col 28.
                write('''</span>
\t\t\t\t\t\t</span>
\t\t\t\t\t</li>
''')
            write('''\t\t\t</ol>
\t\t</li>
\t</ol>

''')
            for sname, eventlist in VFN(VFFSL(SL,"events",True),"items",False)(): # generated from line 183, col 2
                write('''\t\t<ol class="channel-listing">
\t\t\t<li>
\t\t\t\t<span class="ui-widget-header">
\t\t\t\t\t<div>
\t\t\t\t\t\t<h2 class="picon" ><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # '$(picons[$sname])' on line 188, col 36
                if _v is not None: write(_filter(_v, rawExpr='$(picons[$sname])')) # from line 188, col 36.
                write('''" title="''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 188, col 62
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 188, col 62.
                write('''" /></h2>
\t\t\t\t\t\t<span>''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 189, col 13
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 189, col 13.
                write('''</span>
\t\t\t\t\t</div>
\t\t\t\t</span>
\t\t\t\t<ol cass="eventlist">
''')
                c = 0
                ref = ''
                for event in VFFSL(SL,"eventlist",True)[0]: # generated from line 195, col 6
                    pad = 0
                    if VFFSL(SL,"c",True) == 0: # generated from line 197, col 6
                        ref = quote(event['ref'], safe=' ~@#$&()*!+=:;,.?/\'')
                        pad = 141 + (VFFSL(SL,"event.begin_timestamp",True) - VFFSL(SL,"first",True)) / 6
                        write('''\t\t\t\t\t\t<li class="event" style=;width:''')
                        _v = VFFSL(SL,"pad",True) # '${pad}' on line 200, col 38
                        if _v is not None: write(_filter(_v, rawExpr='${pad}')) # from line 200, col 38.
                        write('''px;">
\t\t\t\t\t\t</li>
''')
                    end = VFFSL(SL,"event.begin_timestamp",True) + VFFSL(SL,"event.duration",True)
                    iscurr = ""
                    if VFFSL(SL,"event.begin_timestamp",True) < VFFSL(SL,"now",True) and VFFSL(SL,"end",True) > VFFSL(SL,"now",True): # generated from line 205, col 6
                        iscurr = " ui-state-hover"
                    if VFFSL(SL,"event",True)['timerStatus'] != '': # generated from line 208, col 6
                        iscurr = " ui-state-hover"
                    write('''\t\t\t\t\t<li class="event" data-ref="''')
                    _v = VFFSL(SL,"ref",True) # '$ref' on line 211, col 34
                    if _v is not None: write(_filter(_v, rawExpr='$ref')) # from line 211, col 34.
                    write('''" data-id="''')
                    _v = VFFSL(SL,"event.id",True) # '${event.id}' on line 211, col 49
                    if _v is not None: write(_filter(_v, rawExpr='${event.id}')) # from line 211, col 49.
                    write('''" style="width:''')
                    _v = VFFSL(SL,"event.duration",True)/6 # '${event.duration/6}' on line 211, col 75
                    if _v is not None: write(_filter(_v, rawExpr='${event.duration/6}')) # from line 211, col 75.
                    write('''px;" >
\t\t\t\t\t\t<a href="#" class="ui-widget-content ''')
                    _v = VFFSL(SL,"iscurr",True) # '${iscurr}' on line 212, col 44
                    if _v is not None: write(_filter(_v, rawExpr='${iscurr}')) # from line 212, col 44.
                    write('''" title="''')
                    _v = VFFSL(SL,"event",True)['title'] # "$event['title']" on line 212, col 62
                    if _v is not None: write(_filter(_v, rawExpr="$event['title']")) # from line 212, col 62.
                    write('''">
\t\t\t\t\t\t<span class="ename">''')
                    _v = VFFSL(SL,"event",True)['title'] # "$event['title']" on line 213, col 27
                    if _v is not None: write(_filter(_v, rawExpr="$event['title']")) # from line 213, col 27.
                    write('''</span>
\t\t\t\t\t\t<span class="etime">''')
                    _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"event",True)['begin_timestamp'])) # '$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))' on line 214, col 27
                    if _v is not None: write(_filter(_v, rawExpr='$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))')) # from line 214, col 27.
                    write('''</span>
''')
                    if VFFSL(SL,"event",True)['timerStatus'] != '': # generated from line 215, col 7
                        tt = VFFSL(SL,"event",True)['timer']['text']
                        write('''\t\t\t\t\t\t\t<span class="etimer ''')
                        _v = VFFSL(SL,"event",True)['timerStatus'] # "$event['timerStatus']" on line 217, col 28
                        if _v is not None: write(_filter(_v, rawExpr="$event['timerStatus']")) # from line 217, col 28.
                        write('''">''')
                        _v = VFFSL(SL,"tt",True) # '$tt' on line 217, col 51
                        if _v is not None: write(_filter(_v, rawExpr='$tt')) # from line 217, col 51.
                        write('''</span>
''')
                    write('''\t\t\t\t\t\t</a>
\t\t\t\t\t</li>
''')
                    c = VFFSL(SL,"c",True) + 1
                write('''\t\t\t\t</ol>
\t\t\t</li>
\t\t</ol>
''')
            write('''</div>
''')
        write('''</div>
<div id="eventdescription"></div>

<script>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 233, col 1
            write('''var opena = ''')
            _v = VFFSL(SL,"first",True) # '$first' on line 234, col 13
            if _v is not None: write(_filter(_v, rawExpr='$first')) # from line 234, col 13.
            write(''';
var openb = ''')
            _v = VFFSL(SL,"now",True) # '$now' on line 235, col 13
            if _v is not None: write(_filter(_v, rawExpr='$now')) # from line 235, col 13.
            write(''';
var pos = (openb - opena);
if (pos>0)
\tpos = pos / 6;

''')
            if VFFSL(SL,"day",True) == 0: # generated from line 240, col 1
                write('''
$(".timetable-now").css(\'left\',151+pos);

setTimeout(function() {
\tvar nowdate = Math.round(+new Date()/1000);
\tvar pos = (nowdate - opena);
\tif(pos>0)
\t\tpos = pos / 6;
\t$(".timetable-now").css(\'left\',151+pos);
} ,10000);

$(".timetable-now").css(\'height\',$("#tblinner").height());
''')
            else: # generated from line 253, col 1
                write('''$(".timetable-now").css(\'height\',\'0\');
''')
            write('''
''')
        write('''var picons = ''')
        _v = VFFSL(SL,"dumps",False)(VFFSL(SL,"picons",True)) # '$dumps($picons)' on line 258, col 14
        if _v is not None: write(_filter(_v, rawExpr='$dumps($picons)')) # from line 258, col 14.
        write(''';
var reloadTimers = false;
function getScrollBarWidth () {
\tvar $outer = $(\'<div>\').css({visibility: \'hidden\', width: 100, overflow: \'scroll\'}).appendTo(\'body\'),
\t\twidthWithScroll = $(\'<div>\').css({width: \'100%\'}).appendTo($outer).outerWidth();
\t$outer.remove();
\treturn 100 - widthWithScroll;
}
var scrollBarWidth=getScrollBarWidth();
function fixTableHeight() {
\tvar addScrollBarWidth = scrollBarWidth;
\tif ($(\'#tbl1\').width() <= $("#tvcontent").width()){
\t\taddScrollBarWidth = 0;
\t}
\t
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 273, col 1
            write('''\t$("#tbl1body").height( ($("#tvcontent").height() - $("#navepg").height() - 2*$("#tbl1 thead").height() - addScrollBarWidth - 2) + "px");
''')
        else: # generated from line 275, col 1
            write('''\t$("#tbl1body").height( ($("#tvcontent").height() - $("#navepg").height() - 20 - addScrollBarWidth - 2) + "px");
''')
        write('''\tif (!$(\'#toolbar-header\').is(\':visible\')) {
\t\tvar dh = $(window).height();
\t\t$("#tvcontentmain").height(dh-80);
\t\t$("#tbl1body").height(dh-215);
\t}
}
fixTableHeight();
$(window).resize(function(){ fixTableHeight(); });
$(".bq").click(function() {
\tvar id = $(this).data("ref");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # '$epgmode' on line 288, col 17
        if _v is not None: write(_filter(_v, rawExpr='$epgmode')) # from line 288, col 17.
        write('''";
\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=\'+id +\'&day=''')
        _v = VFFSL(SL,"day",True) # '$day' on line 289, col 74
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 289, col 74.
        write('''&epgmode=\' + epgmode);
\tSetLSValue("lastmbq_"+epgmode,id);
});
$(".event").click(function() {
\tvar id = $(this).data("id");
\tif (id != undefined) {
\t\tvar ref = $(this).data("ref");
\t\t$("#eventdescription").load(\'ajax/event?idev=\'+id+\'&sref=\'+escape(ref), function() {
\t\t\t$("#eventdescription").show(200).draggable( { handle: ".handle" } );
\t\t});
\t}
});
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 301, col 1
            write('''$(".service").click(function() {
\tvar ref = $(this).data("ref");
\tif (ref != undefined) {
\t\tzapChannel(ref, \'\');
\t}
});
''')
        write('''$(".plus").click(function() {
\tvar day = $(this).data("day");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # '$epgmode' on line 311, col 17
        if _v is not None: write(_filter(_v, rawExpr='$epgmode')) # from line 311, col 17.
        write('''";
\tif (day != undefined) {
\t\tif (day > 999)
\t\t{
\t\t\tvar w = day - 1000;
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 316, col 64
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 316, col 64.
        write("""&day='+""")
        _v = VFFSL(SL,"day",True) # '$day' on line 316, col 86
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 316, col 86.
        write('''+\'&epgmode=\'+epgmode+\'&week=\'+w);
\t\t}
\t\telse if (day > 199)
\t\t{
\t\t\tvar d = day - 200;
\t\t\tvar dt = (d==0) ? \'\' : $(this).html();
\t\t\tvar pos = 0;
\t\t\t$(\'#tblinner\').scrollLeft(0);
\t\t\t
\t\t\t$("#timescroller li ol .event").each( function (){
\t\t\t\tif (pos == 0) {
\t\t\t\t\tif ($(this).data("dt") == dt) {
\t\t\t\t\t\tif($(this).position() != undefined)
\t\t\t\t\t\t\tpos = $(this).position().left;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t});
\t\t\t
\t\t\tif(d==\'\')
\t\t\t{
\t\t\t\tvar l = $(".timetable-now").css(\'left\');
\t\t\t\tpos = parseInt(l.replace(\'px\',\'\'));
\t\t\t}
\t\t\t
\t\t\tif(pos>0)
\t\t\t{
\t\t\t\tpos-=200;
\t\t\t\t$(\'#tblinner\').animate({scrollLeft: pos}, 500);
\t\t\t}
\t\t}
\t\telse if (day > 100)
\t\t{
\t\t\tvar mode = day - 100;
\t\t\tif (mode != ''')
        _v = VFFSL(SL,"mode",True) # '$mode' on line 349, col 16
        if _v is not None: write(_filter(_v, rawExpr='$mode')) # from line 349, col 16.
        write(''') {
\t\t\t
\t\t\t\t$.ajax({
\t\t\t\turl: \'api/setwebconfig?mepgmode=\' + mode,
\t\t\t\t\tsuccess: function(data) {
\t\t\t\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 354, col 67
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 354, col 67.
        write('''&day=''')
        _v = VFFSL(SL,"day",True) # '$day' on line 354, col 87
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 354, col 87.
        write("""&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # '$week' on line 354, col 119
        if _v is not None: write(_filter(_v, rawExpr='$week')) # from line 354, col 119.
        write(''');
\t\t\t\t\t}
\t\t\t\t});
\t\t\t}
\t\t}
\t\telse {
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 360, col 64
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 360, col 64.
        write("""&day='+day+'&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # '$week' on line 360, col 119
        if _v is not None: write(_filter(_v, rawExpr='$week')) # from line 360, col 119.
        write(''');
\t\t}
\t} else {
\t\tepgmode = $(this).data("tvradio");
\t\tif (epgmode != undefined) {
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?day=\'+day+\'&epgmode=\'+epgmode);
\t\t}
\t}
});
if(!timeredit_initialized)
\t$(\'#editTimerForm\').load(\'/ajax/edittimer\');

if($("#header").is(\':hidden\')) { 
\t$(\'#compressmepg\').show();$(\'#refreshmepg2\').show();
}
if(mepgdirect==1) {
\tmepgdirect=0;$("#expandmepg").click();
}
$(".togglescroll").click(function() {

\tif($(\'#tblinner\').css(\'overflow-y\')==\'hidden\') {
\t\t$(\'#tblinner\').css(\'overflow-y\',\'\');
\t\t$(\'.togglescroll\').removeClass(\'ui-widget-header\');
\t\tSetLSValue(\'MultiEPGScrollStyle\',\'1\');
\t}else{
\t\t$(\'#tblinner\').css(\'overflow-y\',\'hidden\');
\t\t$(\'.togglescroll\').addClass(\'ui-widget-header\');
\t\tSetLSValue(\'MultiEPGScrollStyle\',\'0\');
\t}
});
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 390, col 1
            write("""$(function() {

\tif(GetLSValue('MultiEPGScrollStyle','0')=='0') {
\t\t$('#tblinner').css('overflow-y','hidden');
\t\t$('.togglescroll').addClass('ui-widget-header');
\t}
\telse
\t{
\t\t$('#tblinner').css('overflow-y','');
\t\t$('.togglescroll').removeClass('ui-widget-header');
\t}

});
""")
        write('''</script>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_multiepg = 'respond'

## END CLASS DEFINITION

if not hasattr(multiepg, '_initCheetahAttributes'):
    templateAPIClass = getattr(multiepg,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(multiepg)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=multiepg()).run()


