#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from six.moves.urllib.parse import quote
from json import dumps
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings
import datetime

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.4.0'
__CHEETAH_versionTuple__ = (3, 4, 0, 'final', 0)
__CHEETAH_genTime__ = 1737444428.327299
__CHEETAH_genTimestamp__ = 'Tue Jan 21 07:27:08 2025'
__CHEETAH_src__ = '/mnt/66db6310-ef67-48e5-833d-28a4e8403d9f/satlodge-dream/build/tmp/work/dm920-oe-linux-gnueabi/enigma2-plugin-extensions-openwebif/git/git/plugin/controllers/views/mobile/timerlist.tmpl'
__CHEETAH_srcLastModified__ = 'Tue Jan 21 06:37:26 2025'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class timerlist(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(timerlist, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<body>
\t<div data-role="page">
\t\t<div id="header">
\t\t\t<div class="button" onclick="history.back()">''')
        _v = VFFSL(SL,"tstrings",True)['back'] # "$tstrings['back']" on line 8, col 49
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['back']")) # from line 8, col 49.
        write('''</div>
\t\t\t<!-- <div class="button-bold">+</div> -->
\t\t\t<h1><a style="color:#FFF;text-decoration:none;" href=\'/mobile\'>OpenWebif</a></h1>
\t\t</div>
\t\t<div id="contentContainer">
\t\t\t<div data-role="collapsibleset">
\t\t\t\t<div data-role="collapsible" data-disabled="true" data-collapsed-icon="false" data-theme="b">
\t\t\t\t\t<h2>''')
        _v = VFFSL(SL,"tstrings",True)['timer_list'] # "$tstrings['timer_list']" on line 15, col 10
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['timer_list']")) # from line 15, col 10.
        write('''</h2>
\t\t\t\t</div>
''')
        oldstartdate = ""
        for timer in VFFSL(SL,"timers",True): # generated from line 18, col 5
            duration = VFFSL(SL,"timer.duration",True)/60
            starttime = datetime.datetime.fromtimestamp(VFFSL(SL,"timer.begin",True)).strftime("%H:%M")
            startdate = datetime.datetime.fromtimestamp(VFFSL(SL,"timer.begin",True)).strftime("%d.%m.%Y")
            endtime = datetime.datetime.fromtimestamp(VFFSL(SL,"timer.end",True)).strftime("%H:%M")
            if VFFSL(SL,"startdate",True) != VFFSL(SL,"oldstartdate",True): # generated from line 23, col 5
                if VFFSL(SL,"oldstartdate",True) != "": # generated from line 24, col 5
                    write('''\t\t\t\t\t</ul>
\t\t\t\t</div>
\t\t\t\t<div data-role="collapsible">
''')
                else: # generated from line 28, col 5
                    write('''\t\t\t\t<div data-role="collapsible" data-collapsed="false">
''')
                write('''\t\t\t\t\t<h2>''')
                _v = VFFSL(SL,"startdate",True) # '$startdate' on line 31, col 10
                if _v is not None: write(_filter(_v, rawExpr='$startdate')) # from line 31, col 10.
                write('''</h2>
''')
                oldstartdate = VFFSL(SL,"startdate",True)
                write('''\t\t\t\t\t<ul data-role="listview" data-inset="false" data-theme="a">
''')
            write('''\t\t\t\t\t<li>
''')
            sref = quote(VFFSL(SL,"timer.serviceref",True), safe=' ~@#$&()*!+=:;,.?/\'')
            name = quote(VFFSL(SL,"timer.name",True), safe=' ~@#$&()*!+=:;,.?/\'').replace("'","\\'")
            write('''\t\t\t\t\t\t<a href="#">
\t\t\t\t\t\t\t<h2>''')
            _v = VFFSL(SL,"timer.name",True) # '$timer.name' on line 39, col 12
            if _v is not None: write(_filter(_v, rawExpr='$timer.name')) # from line 39, col 12.
            write('''</h2>
\t\t\t\t\t\t\t<p><strong>''')
            _v = VFFSL(SL,"timer.servicename",True) # '$timer.servicename' on line 40, col 19
            if _v is not None: write(_filter(_v, rawExpr='$timer.servicename')) # from line 40, col 19.
            write(''' - ''')
            _v = VFFSL(SL,"starttime",True) # '$starttime' on line 40, col 40
            if _v is not None: write(_filter(_v, rawExpr='$starttime')) # from line 40, col 40.
            write(''' - ''')
            _v = VFFSL(SL,"endtime",True) # '$endtime' on line 40, col 53
            if _v is not None: write(_filter(_v, rawExpr='$endtime')) # from line 40, col 53.
            write(''' (''')
            _v = VFFSL(SL,"duration",True) # '$duration' on line 40, col 63
            if _v is not None: write(_filter(_v, rawExpr='$duration')) # from line 40, col 63.
            write(''' min)</strong></p>
\t\t\t\t\t\t\t<p>''')
            _v = VFFSL(SL,"timer.description",True) # '$timer.description' on line 41, col 11
            if _v is not None: write(_filter(_v, rawExpr='$timer.description')) # from line 41, col 11.
            write('''</p>
\t\t\t\t\t\t</a>
\t\t\t\t\t\t<a href="#" onclick="deleteTimer(\'''')
            _v = VFFSL(SL,"sref",True) # '$sref' on line 43, col 41
            if _v is not None: write(_filter(_v, rawExpr='$sref')) # from line 43, col 41.
            write("""', '""")
            _v = VFFSL(SL,"timer.begin",True) # '$timer.begin' on line 43, col 50
            if _v is not None: write(_filter(_v, rawExpr='$timer.begin')) # from line 43, col 50.
            write("""', '""")
            _v = VFFSL(SL,"timer.end",True) # '$timer.end' on line 43, col 66
            if _v is not None: write(_filter(_v, rawExpr='$timer.end')) # from line 43, col 66.
            write("""', '""")
            _v = VFFSL(SL,"name",True) # '$name' on line 43, col 80
            if _v is not None: write(_filter(_v, rawExpr='$name')) # from line 43, col 80.
            write('''\');" aria-expanded="false" class="ui-btn ui-btn-icon-notext ui-icon-delete ui-btn-a" title="delete"></a>
\t\t\t\t\t</li>
''')
        write('''\t\t\t\t</ul>
\t\t\t</div>
\t\t\t<button onclick="document.location.reload(true)">''')
        _v = VFFSL(SL,"tstrings",True)['refresh'] # "$tstrings['refresh']" on line 48, col 53
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['refresh']")) # from line 48, col 53.
        write('''</button>
\t\t</div>
\t\t<div id="footer">
\t\t\t<p>OpenWebif Mobile</p>
\t\t\t<a onclick="document.location.href=\'/index?mode=fullpage\';return false;" href="#">''')
        _v = VFFSL(SL,"tstrings",True)['show_full_openwebif'] # "$tstrings['show_full_openwebif']" on line 52, col 86
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['show_full_openwebif']")) # from line 52, col 86.
        write('''</a>
\t\t</div>
\t<script>
\tfunction deleteTimer(sRef, begin, end, title) {
\t\tvar t = decodeURIComponent(title);
\t\tif (confirm("''')
        _v = VFFSL(SL,"tstrings",True)['delete_timer_question'] # "$tstrings['delete_timer_question']" on line 57, col 16
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['delete_timer_question']")) # from line 57, col 16.
        write('''" + ": " + t) === true) {
\t\t\t$.ajax({ url: "/api/timerdelete?sRef=" + sRef + "&begin=" + begin + "&end=" + end, cache: false, async: false}).done(function() {
\t\t\t\tlocation.reload(true);
\t\t\t});
\t\t}
\t}
\t</script>
</div>
</body>
</html>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_timerlist = 'respond'

## END CLASS DEFINITION

if not hasattr(timerlist, '_initCheetahAttributes'):
    templateAPIClass = getattr(timerlist,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(timerlist)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=timerlist()).run()


