#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from six.moves.urllib.parse import quote
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.3.3'
__CHEETAH_versionTuple__ = (3, 3, 3, 'final', 0)
__CHEETAH_genTime__ = 1704536008.390211
__CHEETAH_genTimestamp__ = 'Sat Jan  6 10:13:28 2024'
__CHEETAH_src__ = '/media/daimon/61c88a30-8b91-4a81-8b0a-975af139a961/dream/build/tmp/work/dm920-oe-linux-gnueabi/enigma2-plugin-extensions-openwebif/git/git/plugin/controllers/views/mobile/eventview.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Jan  6 09:24:27 2024'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class eventview(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(eventview, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<body>
\t<div data-role="page">
\t\t<div id="header">
\t\t<div class="button" onclick="history.back()">''')
        _v = VFFSL(SL,"tstrings",True)['back'] # "$tstrings['back']" on line 6, col 48
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['back']")) # from line 6, col 48.
        write('''</div>
\t\t<h1><a style="color:#FFF;text-decoration:none;" href=\'/mobile\'>OpenWebif</a></h1>
''')
        sref = quote(VFFSL(SL,"event.sref",True), safe=' ~@#$&()*!+=:;,.?/\'')
        write('''\t\t<div class="button" style="right:5px;left:auto;" onclick="addTimerEvent(\'''')
        _v = VFFSL(SL,"sref",True) # '$sref' on line 9, col 76
        if _v is not None: write(_filter(_v, rawExpr='$sref')) # from line 9, col 76.
        write("""',""")
        _v = VFFSL(SL,"event.id",True) # '$event.id' on line 9, col 83
        if _v is not None: write(_filter(_v, rawExpr='$event.id')) # from line 9, col 83.
        write(''');return false;">''')
        _v = VFFSL(SL,"tstrings",True)['add_timer'] # "$tstrings['add_timer']" on line 9, col 109
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['add_timer']")) # from line 9, col 109.
        write('''</div>
\t</div>
\t\t<div id="mainContent" class="ui-corner-all">
\t\t\t<table width="100%" border="0" cellspacing="1" cellpadding="5">
\t\t\t\t\t\t\t<tr>
\t\t\t\t\t\t\t\t<th colspan="3" class="ui-btn-up-b" style="text-align: left;">''')
        _v = VFFSL(SL,"tstrings",True)['service'] # "$tstrings['service']" on line 14, col 71
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['service']")) # from line 14, col 71.
        write('''</th>
\t\t\t\t\t\t\t</tr>
\t\t\t\t\t\t\t<tr style="background-color:  #f0f7fc;">
\t\t\t\t\t\t\t\t<td width="200"><img src="''')
        _v = VFFSL(SL,"event",True)['picon'] # "$event['picon']" on line 17, col 35
        if _v is not None: write(_filter(_v, rawExpr="$event['picon']")) # from line 17, col 35.
        write('''" border="0" alt=""></td>
\t\t\t\t\t\t\t\t<td width="100%" valign="top">
\t\t\t\t\t\t\t\t<strong>''')
        _v = VFFSL(SL,"event",True)['channel'] # "$event['channel']" on line 19, col 17
        if _v is not None: write(_filter(_v, rawExpr="$event['channel']")) # from line 19, col 17.
        write('''</strong><br />
\t\t\t\t\t\t\t\t\t''')
        _v = VFFSL(SL,"event",True)['title'] # "$event['title']" on line 20, col 10
        if _v is not None: write(_filter(_v, rawExpr="$event['title']")) # from line 20, col 10.
        write('''<br />
\t\t\t\t\t\t\t\t\t''')
        _v = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(VFFSL(SL,"event",True)['start']))))] # '$tstrings[("day_" + (time.strftime("%w", time.localtime($event[\'start\']))))]' on line 21, col 10
        if _v is not None: write(_filter(_v, rawExpr='$tstrings[("day_" + (time.strftime("%w", time.localtime($event[\'start\']))))]')) # from line 21, col 10.
        write(''', ''')
        _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%d.%m.%Y", time.localtime(VFFSL(SL,"event",True)['start'])) # '$time.strftime("%d.%m.%Y", time.localtime($event[\'start\']))' on line 21, col 88
        if _v is not None: write(_filter(_v, rawExpr='$time.strftime("%d.%m.%Y", time.localtime($event[\'start\']))')) # from line 21, col 88.
        write(''' / ''')
        _v = VFFSL(SL,"event",True)['begin'] # "$event['begin']" on line 21, col 150
        if _v is not None: write(_filter(_v, rawExpr="$event['begin']")) # from line 21, col 150.
        write(''' - ''')
        _v = VFFSL(SL,"event",True)['end'] # "$event['end']" on line 21, col 168
        if _v is not None: write(_filter(_v, rawExpr="$event['end']")) # from line 21, col 168.
        write(''' ( ''')
        _v = VFFSL(SL,"event",True)['duration'] # "$event['duration']" on line 21, col 184
        if _v is not None: write(_filter(_v, rawExpr="$event['duration']")) # from line 21, col 184.
        write(''' min )<br />
\t\t\t\t\t\t\t\t</td>
\t\t\t\t\t\t\t</tr>
\t\t\t\t\t\t\t<tr>
\t\t\t\t\t\t\t\t<th colspan="2" class="ui-btn-up-b" style="text-align: left;">''')
        _v = VFFSL(SL,"tstrings",True)['description'] # "$tstrings['description']" on line 25, col 71
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['description']")) # from line 25, col 71.
        write('''</th>
\t\t\t\t\t\t\t</tr>
\t\t\t\t\t\t\t<tr style="background-color:  #f0f7fc;">
\t\t\t\t\t\t\t\t<td colspan="2">''')
        _v = VFFSL(SL,"event",True)['shortdesc'] # "$event['shortdesc']" on line 28, col 25
        if _v is not None: write(_filter(_v, rawExpr="$event['shortdesc']")) # from line 28, col 25.
        write('''</td>
\t\t\t\t\t\t\t</tr>
\t\t\t\t\t\t\t<tr style="background-color:  #f0f7fc;">
\t\t\t\t\t\t\t\t<td colspan="2">''')
        _v = VFFSL(SL,"event",True)['longdesc'] # "$event['longdesc']" on line 31, col 25
        if _v is not None: write(_filter(_v, rawExpr="$event['longdesc']")) # from line 31, col 25.
        write('''</td>
\t\t\t\t\t\t\t</tr>
\t\t\t\t</table>
\t\t\t\t<button onclick="location=\'/mobile/timerlist\'">''')
        _v = VFFSL(SL,"tstrings",True)['timer_list'] # "$tstrings['timer_list']" on line 34, col 52
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['timer_list']")) # from line 34, col 52.
        write('''</button>
\t\t</div>
\t\t<div id="footer">
\t\t<p>OpenWebif Mobile</p>
\t\t<a onclick="document.location.href=\'/index?mode=fullpage\';return false;" href="#">''')
        _v = VFFSL(SL,"tstrings",True)['show_full_openwebif'] # "$tstrings['show_full_openwebif']" on line 38, col 85
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['show_full_openwebif']")) # from line 38, col 85.
        write('''</a>
\t\t</div>
<script type="text/javascript">
function addTimerEvent(sRef, eventId) {
\tvar url = "/api/timeraddbyeventid?sRef=" + sRef + "&eventid=" + eventId;
\t$.ajax({
\t\tasync: false,
\t\turl: url,
\t\tcache : false,
\t\tdataType: \'json\',
\t\tsuccess: function(result) {
\t\t\tif(result) {
\t\t\t\tif(!result.result && result.conflicts)
\t\t\t\t\talert( "Error Timer Confict" );
\t\t\t\telse
\t\t\t\t\talert( result.result ? "''')
        _v = VFFSL(SL,"tstrings",True)['tstr_timer_added'] # "$tstrings['tstr_timer_added']" on line 53, col 30
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['tstr_timer_added']")) # from line 53, col 30.
        write('''" : result.message );
\t\t\t} else
\t\t\t\talert( "Error Creating Timer" );
\t\t}
\t});
}
</script>
</body>
</html>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_eventview = 'respond'

## END CLASS DEFINITION

if not hasattr(eventview, '_initCheetahAttributes'):
    templateAPIClass = getattr(eventview,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(eventview)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=eventview()).run()


