#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

LIBS=/usr/lib/libopen.so.0.0.0

# enigma main loop
while : ; do
	# show bootlogo on enigma2 start
	if [ -x /usr/bin/showiframe ]; then
		if [ -f /etc/enigma2/backdrop.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/backdrop.mvi
		elif [ -f /etc/enigma2/bootlogo.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/bootlogo.mvi
		elif [ -f /usr/share/bootlogo.mvi ]; then
			/usr/bin/showiframe /usr/share/bootlogo.mvi
		fi
	fi

	# hook to execute scripts always before enigma2 start
	if [ -x /usr/bin/enigma2_pre_start.sh ]; then
		/usr/bin/enigma2_pre_start.sh
	fi

	# start enigma
	sync
	if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=true" ]; then
		RANDOMIZE1970=''
		time=`date +%Y` ;
		if [ "$time" = 1970 ]; then
			RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
		fi
		LOGFOLDER="/home/root/logs/"
		if [ ! -d $LOGFOLDER ] ; then mkdir -p $LOGFOLDER; fi
		if [ "$(grep config.crash.debugPath= /etc/enigma2/settings | sed 's/config.crash.debugPath=//g')" != "" -a -d "$(grep config.crash.debugPath= /etc/enigma2/settings | sed 's/config.crash.debugPath=//g')" ]; then
			LOGFOLDER=$(grep config.crash.debugPath= /etc/enigma2/settings | sed 's/config.crash.debugPath=//g')
		fi
		LD_PRELOAD=$LIBS /usr/bin/enigma2 --debug-no-color $VERBOSE &> ${LOGFOLDER}Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)${RANDOMIZE1970}.log
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 $VERBOSE
	fi


	# enigma2 exit codes:
	#
	#  1 - halt
	#  2 - reboot
	#  3 - restart enigma in normal mode
	#  4 - front processor upgrade
	#  5 - install new settings
	#  6 - restart enigma in debug mode
	#  7 - manufacturer reset
	# 42 - offline update
	# 43 - restart for autoinstall
	#
	# >128 signal

	ret=$?
	case $ret in
		1)
			/sbin/halt
			;;
		2)
			/sbin/reboot
			;;
		3)
			ENIGMA_DEBUG_LVL=3
			;;
		4)
			/sbin/rmmod lcd
			/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
			sleep 1;
			/sbin/rmmod fp
			/sbin/modprobe fp
			/sbin/reboot
			;;
		5)
			if ! grep -q config.misc.RestartUI /etc/enigma2/settings; then
				echo "config.misc.RestartUI=true" >>/etc/enigma2/settings
			fi
			;;
		6)
			ENIGMA_DEBUG_LVL="4"
			;;
		7)
			rm -R /etc/enigma2
			;;
		42)
			df -P | grep -v "tmpfs " | awk '{print $6}' | tail -n +3 > /tmp/upgrade_mountpoints.txt
			while read line; do
				if [  -f $line/var/lib/opkg/status ]; then
				DESTS=$DESTS" --add-dest "$line":"$line
			fi
			done < /tmp/upgrade_mountpoints.txt
			# bind the console (when available)
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			prevupd=0
			currupd=999
			opkg update 2>&1 | tee /home/root/opkgupgrade.log
			while [ $currupd -gt 0 -a $currupd -ne $prevupd ]; do
				opkg upgrade $DESTS 2>&1 | tee -a /home/root/opkgupgrade.log
				prevupd=$currupd
				currupd=`opkg list-upgradable | wc -l`
				echo "===> $currupd PACKAGE(S) REMAINING" >> /home/root/ipkupgrade.log
			done
			/sbin/reboot
			;;
		43)
			#auto install and autobackup
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			/etc/init.d/settings-restore.sh
			/etc/init.d/avahi-daemon stop
			ifdown eth1
			ip addr flush dev eth1 scope global
			ifdown eth0
			ip addr flush dev eth0 scope global
			/etc/init.d/networking stop
			killall -9 udhcpc
			rm /var/run/udhcpc*
			/etc/init.d/dbus-1 reload
			/etc/init.d/networking start
			/etc/init.d/avahi-daemon start
			if [ ! -f /etc/.doNotAutoinstall ]; then
				touch /etc/.doAutoinstall
			else
				rm -f /etc/.doNotAutoInstall
			fi
			break
			;;
		*)
			break
			;;
	esac

done
