#
#   wrapper.py: Small class to wrap an object, instantiated from a class
#       or generated by a module.
#
# ===================================================================
# The contents of this file are dedicated to the public domain.  To
# the extent that dedication to the public domain is not available,
# everyone is granted a worldwide, perpetual, royalty-free,
# non-exclusive license to exercise all rights associated with the
# contents of this file for any purpose whatsoever.
# No rights are reserved.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# ===================================================================
#

__all__ = [ 'Wrapper' ]

class Wrapper:
    '''
    Wrapper for an object, instantiated from a class
    or from a call to a new() function in a module.
    '''
    def __init__(self, wrapped, *args):
        """
        wrapped is either a class or a module with a new() function.
        """
        if hasattr(wrapped, 'new'):
            self._wrapped = wrapped.new(*args)
        else:
            self._wrapped = wrapped(*args)
    
    def __getattr__(self, name):
        try:
            return getattr(getattr(self,'_wrapped'),name)
        except AttributeError:
            if hasattr(self, name):
                return getattr(self,name)
            raise

