#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

# any debuglevel passed?
if [ -z $ENIGMA_DEBUG_LVL ]; then
	DEBUG_LVL=3
else
	DEBUG_LVL=$ENIGMA_DEBUG_LVL
fi

# LC_ALL available?
if [ -z $LC_ALL ]; then
	export LC_ALL=en_GB.utf8
fi

LIBS=/usr/lib/libopen.so.0.0.0

# enigma main loop
while : ; do
	# show bootlogo on enigma2 start
	if [ -x /usr/bin/showiframe ]; then
		if [ -f /etc/enigma2/backdrop.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/backdrop.mvi
		elif [ -f /etc/enigma2/bootlogo.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/bootlogo.mvi
		elif [ -f /usr/share/bootlogo.mvi ]; then
			/usr/bin/showiframe /usr/share/bootlogo.mvi
		fi
	fi

	# hook to execute scripts always before enigma2 start
	if [ -x /usr/bin/enigma2_pre_start.sh ]; then
		/usr/bin/enigma2_pre_start.sh
	fi

	# start enigma
	sync
	if [ $DEBUG_LVL -lt 4 ]; then
		LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2
	else
		# remove old logfiles
		keep=5;
		for file in `ls -t /home/root/enigma.*.debuglog`; do let "keep--"; if [ "$keep" -lt "0" ]; then rm $file; fi; done
		# todays log file
		file="/home/root/enigma.$(date +%Y%m%d).debuglog"
		LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2 >> $file 2>&1
	fi


	# enigma2 exit codes:
	#
	#  1 - halt
	#  2 - reboot
	#  3 - restart enigma in normal mode
	#  4 - front processor upgrade
	#  5 - install new settings
	#  6 - restart enigma in debug mode
	#  7 - manufacturer reset
	# 42 - restart for unattended update
	# 43 - restart for network restore
	# 44 - restart for autobackup restore
	#
	# >128 signal

	ret=$?
	case $ret in
		1)
			/sbin/halt
			;;
		2)
			/sbin/reboot
			;;
		3)
			DEBUG_LVL=3
			;;
		4)
			/sbin/rmmod lcd
			/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
			sleep 1;
			/sbin/rmmod fp
			/sbin/modprobe fp
			/sbin/reboot
			;;
		5)
			if ! grep -q config.misc.RestartUI /etc/enigma2/settings; then
				echo "config.misc.RestartUI=true" >>/etc/enigma2/settings
			fi
			;;
		6)
			DEBUG_LVL=4
			;;
		7)
			rm -R /etc/enigma2
			;;
		42)
			# bind the console (when available)
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			prevupd=0
			currupd=999
			opkg update 2>&1 | tee /home/root/opkgupgrade.log
			# check if we need to upgrade busybox first
			if [ "$(opkg list-upgradable busybox)" != "" ]; then
				opkg update busybox 2>&1 | tee -a /home/root/opkgupgrade.log
			fi
			# update all other packages installed on the rootfs
			while [ $currupd -gt 0 -a $currupd -ne $prevupd ]; do
				opkg upgrade 2>&1 | tee -a /home/root/opkgupgrade.log
				prevupd=$currupd
				currupd=`opkg list-upgradable | wc -l`
				echo "===> $currupd PACKAGE(S) REMAINING" >> /home/root/opkgupgrade.log
			done
			# and remaining install destinations
			df -P | grep -v "tmpfs " | awk '{print $6}' | tail -n +3 > /tmp/upgrade_mountpoints.txt
			while read line; do
				if [  -f $line/var/lib/opkg/status ]; then
				DESTS=$DESTS" --add-dest "$line":"$line
			fi
			done < /tmp/upgrade_mountpoints.txt
			if [ "$DESTS" != "" ]; then
				opkg upgrade $DESTS 2>&1 | tee -a /home/root/opkgupgrade.log
			fi
			/sbin/reboot
			;;
		43)
			# restore only network from autobackup
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			/etc/init.d/settings-restore.sh network
			break
			;;
		44)
			# restore autobackup
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			/etc/init.d/settings-restore.sh
			[ -f /etc/init.d/softcam ] && /etc/init.d/softcam restart
			break
			;;
		*)
			break
			;;
	esac

done
