from __future__ import absolute_import, print_function

from . import xmltvconverter

date_format = '%Y%m%d%H%M%S'
gen_categories = {
	"Action sports": (0x40, 0),
	"Action": (0x10, 0),
	"Adult Movie/Drama": (0x18, 0),
	"Adults only": (0x18, 0),
	"Adventure/Western/War": (0x12, 0),
	"Advertisement/Shopping": (0xA6, 0),
	"Aerobics": (0xA4, 0),
	"Animated": (0x55, 0),
	"Archery": (0x46, 0),
	"Arts/Culture": (0x70, 0),
	"Athletics": (0x46, 0),
	"Ballet": (0x66, 0),
	"Baseball": (0x45, 0),
	"Basketball": (0x45, 0),
	"Bicycle": (0x40, 0),
	"Billiards": (0x40, 0),
	"Black & White": (0xB2, 0),
	"Boxing": (0x40, 0),
	"Broadcasting/Press": (0x78, 0),
	"Cartoons/Puppets": (0x55, 0),
	"Children's/Youth Programme": (0x50, 0),
	"Comedy": (0x14, 0),
	"Comedy-drama": (0x14, 0),
	"Cooking": (0xA5, 0),
	"Crime drama": (0x10, 0),
	"Crime/Mystery": (0x10, 85),
	"Detective/Thriller": (0x11, 0),
	"Discussion/Interview/Debate": (0x24, 0),
	"Documentary": (0x23, 0),
	"Drama": (0x10, 0),
	"Economics/Social Advisory": (0x82, 0),
	"Education/Science/Factual": (0x90, 0),
	"Educational": (0x90, 0),
	"Entertainment Programme for 10 to 16": (0x53, 0),
	"Entertainment Programme for 6 to 14": (0x52, 0),
	"Equestrian": (0x4A, 0),
	"Experimental Film/Video": (0x77, 0),
	"Fashion": (0x7B, 0),
	"Film": (0x10, 0),
	"Film/Cinema": (0x76, 0),
	"Fine Arts": (0x72, 0),
	"Fitness & Health": (0xA4, 0),
	"Folk/Traditional Music": (0x63, 0),
	"Football/Soccer": (0x43, 0),
	"Foreign Countries/Expeditions": (0x94, 0),
	"Further Education": (0x96, 0),
	"Game Show/Quiz/Contest": (0x31, 0),
	"Gardening": (0xA7, 0),
	"Handicraft": (0xA2, 0),
	"Hobbies": (0x30, 0),
	"Informational/Educational/School Programme": (0x54, 0),
	"Jazz": (0x64, 0),
	"Languages": (0x97, 0),
	"Leisure/Hobbies": (0xA0, 0),
	"Literature": (0x75, 0),
	"Live Broadcast": (0xB4, 0),
	"Magazine/Report/Documentary": (0x81, 0),
	"Martial Sports": (0x4B, 0),
	"Medicine/Physiology/Psychology": (0x93, 0),
	"Motor Sport": (0x47, 0),
	"Motoring": (0xA3, 0),
	"Movie/Drama": (0x10, 0),
	"Music": (0x60, 0),
	"Music/Ballet/Dance": (0x60, 0),
	"Musical/Opera": (0x65, 0),
	"Nature/Animals/Environment": (0x91, 0),
	"New Media": (0x79, 0),
	"News Magazine": (0x22, 0),
	"News": (0x20, 0),
	"News/Current Affairs": (0x20, 0),
	"News/Weather Report": (0x21, 0),
	"Original Language": (0xB1, 0),
	"Paid Programming": (0x54, 0),
	"Performing Arts": (0x71, 0),
	"Popular Culture/Traditional Arts": (0x74, 0),
	"Pre-school Children's Programme": (0x51, 0),
	"Reality": (0x34, 0),
	"Religion": (0x73, 0),
	"Religious": (0x73, 0),
	"Remarkable People": (0x83, 0),
	"Rock/Pop": (0x61, 0),
	"Romance": (0x16, 0),
	"Science Fiction/Fantasy/Horror": (0x13, 0),
	"Science/Nature": (0x90, 0),
	"Serious/Classical Music": (0x62, 0),
	"Serious/Classical/Religious/Historical Movie/Drama": (0x17, 0),
	"Show/Game Show": (0x30, 0),
	"Soap": (0x15, 0),
	"Soap/Melodrama/Folkloric": (0x15, 0),
	"Social/Political/Economics": (0x80, 0),
	"Social/Spiritual Sciences": (0x95, 0),
	"Special Event": (0x41, 0),
	"Sport Magazine": (0x42, 0),
	"Sports": (0x40, 0),
	"Standup": (0x14, 0),
	"Talk Show": (0x33, 0),
	"Talk": (0x33, 0),
	"Team Sports": (0x45, 0),
	"Technology/Natural Sciences": (0x92, 0),
	"Tennis/Squash": (0x44, 0),
	"Tourism/Travel": (0xA1, 0),
	"Unknown": (0x00, 0),
	"Unpublished": (0xB3, 0),
	"Variety Show": (0x32, 0),
	"Water Sport": (0x48, 0),
	"Weather": (0x21, 0),
	"Winter Sports": (0x49, 0),
}


def new():
	'Factory method to return main class instance'
	return Gen_Xmltv()


class Gen_Xmltv():
	def iterator(self, fd, channelsDict, offset=0):
		try:
			xmltv_parser = xmltvconverter.XMLTVConverter(channelsDict, gen_categories, date_format, offset)
			for r in xmltv_parser.enumFile(fd):
				yield r
		except Exception as e:
			print("[gen_xmltv] Error:", e)
			import traceback
			traceback.print_exc()
