#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
import six
from six.moves.urllib.parse import quote
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings
from json import dumps
from time import localtime, strftime, mktime
from Plugins.Extensions.OpenWebif.controllers.views.responsive.ajax.renderevtblock import renderEvtBlock

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.3.3.post1'
__CHEETAH_versionTuple__ = (3, 3, 3, 'post', 1)
__CHEETAH_genTime__ = 1714564399.2046597
__CHEETAH_genTimestamp__ = 'Wed May  1 11:53:19 2024'
__CHEETAH_src__ = '/media/daimon/61c88a30-8b91-4a81-8b0a-975af139a961/dreamsl/build/tmp/work/dm920-oe-linux-gnueabi/enigma2-plugin-extensions-openwebif/git/git/plugin/controllers/views/responsive/ajax/multiepg.tmpl'
__CHEETAH_srcLastModified__ = 'Wed May  1 10:37:31 2024'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class multiepg(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(multiepg, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
<!-- TODO: move styles to css file -->
<style>
\ttable { font-size: 13px; }
\ttr { vertical-align: top }
\t.float { float:left }
\t.service { font-weight: bold; font-size: 12px; padding-right: 4px; white-space: nowrap; overflow: hidden; }
\t.service img { width:50px; height:30px; float:none; margin-right:10px; border: 0; }
\t.serviceheader { padding: 10px; width: 190px; text-align: center; background-color: #bababa; box-shadow: inset -20px 40px 60px #fff; }
\t.theme--city-lights .serviceheader { background-color: #313443; box-shadow: inset -20px 40px 60px #282c37; }
\t.event { cursor: pointer; width: 190px; overflow:hidden; }
\t.bq { font-size: 12px; padding: 2px 4px; line-height: 18px; cursor: pointer; white-space: nowrap; display: inline-block; margin: 1px 1px 0px 0px;}
\t.plusclick { font-size: 14px; }
\t.navtab-active { cursor: pointer; margin-right:8px; font-weight: bold; border-bottom-width: 2px; border-bottom-style: solid; background-color: transparent !important; bottom: 2px;}
\t.navtab-inactive { cursor: pointer; margin-right:8px; border:None; background-color: transparent !important;  }
\t.timer { font-weight: bold; font-size: 10px; color:red; }
\t#eventdescription { width: 375px; height: auto; position: fixed; top: 205px; left: 350px; z-index: 100; display: none; overflow: auto; }
\t#navepg { margin-bottom: 1px; }
''')
        if VFFSL(SL,"mode",True) != 2: # generated from line 25, col 1
            write('''\t#tbl1 tbody { width: 100%; height: 100%; overflow-y: auto; display: block; overflow-x: hidden;}
\t#tbl2 tbody { width: 100%; height: 100%; overflow-y: hidden; display: block; overflow-x: hidden;}
\t#fulltbl { width: 100%; height: 100%; overflow-y: hidden; display: block; overflow-x: auto;}
''')
        write('''\t.notablemargin { margin: 0px;}
\t.ui-widget-content.nobg , .ui-widget-header.nobg{ background-image: none; } 
\t.wrapper { overflow-x: auto; width: 100%; -ms-overflow-style: -ms-autohiding-scrollbar;}
\ttd.border { width: 190px; }

\t.epg__event { display: flex; flex-wrap: wrap; padding: 0 0.2em 1em; }
\t.epg__time--start { flex: 0 1 2.8em }
\t.epg__title { font-weight: bold; margin-bottom: 0.2ex; flex: 1 0 0; display: block; }
\t.epg__desc { cursor: pointer; width: 190px; overflow:hidden; max-height: 3.75em; overflow: hidden; line-height: 1.25em; font-size: 12px; text-align: justify; padding-right: 1em; }
\t@supports (-webkit-line-clamp: 4) { .epg__desc { max-height: none; display: -webkit-box; -webkit-line-clamp: 4; -webkit-box-orient: vertical; overflow: hidden; } }
\timg[src*="default_picon"] { filter: grayscale(1) opacity(0.5); }

\t#fulltbl .table-striped>tbody>tr:hover,
\t#fulltbl .table-striped>tbody>tr:nth-of-type(odd):hover,
\t#fulltbl .theme--city-lights .table-striped>tbody>tr:hover,
\t#fulltbl .theme--city-lights .table-striped>tbody>tr:nth-of-type(odd):hover { 
\t/* background-color: initial; */
\t}
\t.epg__event:hover {
\t\tfilter: brightness(1.2);
\t}
\t.epg__event:hover .epg__title {
\t\t\ttext-decoration: underline;
\t}
\t.epg__event.event--has-timer {
    position: relative;
    overflow: visible;
\t}
\t.epg__event.event--has-timer::after {
\tcontent: \'\';
    display: block;
    border-radius: 0;
    top: -25%;
    right: 0;
    bottom: -10%;
    left: -10px;
    position: absolute;
    border-width: 0 0 0 3px;
\tborder-style: solid;
  \t}
\t.epg__timer-status .material-icons {
\t\tfont-size: 1.2em;
    margin-right: 0.6ex;
    /* margin-bottom: 0.2ex; */
    vertical-align: text-top;
    /* line-height: 1.2; */
    float: left;
\t}
\t.epg__row {
    border: solid;
    border-width: 1px 0px 0px 0px;
    height: 60px !important;
    margin: 0;
    box-shadow: 5px 0px 2px -3px rgba(0, 0, 0, 0.2);
\t}
\t.epg__channel {
    width: 125px !important;
    margin-left: 15px;
    padding-right: 18px;
\t}
\t.epg__channel label {
    font-size: 11px;
    line-height: 1;
\t}
</style>

<div id="navepg">
<ul class="nav nav-tabs tab--skinned" style="margin-top: -10px;">
''')
        for slot in list(range(0,7)): # generated from line 98, col 1
            write('''\t<li><div class="plusclick navtab-''')
            if VFFSL(SL,"slot",True)==VFFSL(SL,"day",True) : # generated from line 99, col 35
                _v =  'active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  'inactive' 
                if _v is not None: write(_filter(_v))
            write('''" data-day="''')
            _v = VFFSL(SL,"slot",True) # '$(slot)' on line 99, col 94
            if _v is not None: write(_filter(_v, rawExpr='$(slot)')) # from line 99, col 94.
            write('''">''')
            _v = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))] # '$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]' on line 99, col 103
            if _v is not None: write(_filter(_v, rawExpr='$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]')) # from line 99, col 103.
            write('''</div></li>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 101, col 1
            write('''<li><div class="plusclick lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['prime_times'] # "$tstrings['prime_times']" on line 102, col 38
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['prime_times']")) # from line 102, col 38.
            write(''':&nbsp;</div></li>
<li><div id="pt0" class="plusclick navtab-inactive" data-day="201">06:00</div></li>
<li><div id="pt1" class="plusclick navtab-inactive" data-day="202">12:00</div></li>
<li><div id="pt2" class="plusclick navtab-inactive" data-day="203">20:00</div></li>
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 106, col 1
                write('''\t\t<li><div id="pt3" class="plusclick navtab-inactive">&nbsp;</div>
<li><div id="pt4" class="plusclick navtab-active" data-day="200">''')
                _v = VFFSL(SL,"tstrings",True)['now'] # "$tstrings['now']" on line 108, col 66
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['now']")) # from line 108, col 66.
                write('''</div></li>
''')
            write('''
''')
        else: # generated from line 111, col 1
            write('''<li><div class="plusclick lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['cw'] # "$tstrings['cw']" on line 112, col 38
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['cw']")) # from line 112, col 38.
            write(''':&nbsp;</div></li>
''')
            for wk in list(range(0,3)): # generated from line 113, col 1
                w = VFFSL(SL,"wk",True) + 1000
                write('''\t<li><div class="plusclick navtab-''')
                if VFFSL(SL,"wk",True)==VFFSL(SL,"week",True) : # generated from line 115, col 35
                    _v =  'active' 
                    if _v is not None: write(_filter(_v))
                else:
                    _v =  'inactive' 
                    if _v is not None: write(_filter(_v))
                write('''" data-day="''')
                _v = VFFSL(SL,"w",True) # '$(w)' on line 115, col 93
                if _v is not None: write(_filter(_v, rawExpr='$(w)')) # from line 115, col 93.
                write('''">''')
                _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%V",time.localtime(time.time()+604800*wk)) # '$time.strftime("%V",time.localtime(time.time()+604800*wk))' on line 115, col 99
                if _v is not None: write(_filter(_v, rawExpr='$time.strftime("%V",time.localtime(time.time()+604800*wk))')) # from line 115, col 99.
                write('''</div></li>
''')
        write('''<li><div class=" lbl">&nbsp;''')
        _v = VFFSL(SL,"tstrings",True)['display_mode'] # "$tstrings['display_mode']" on line 118, col 29
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['display_mode']")) # from line 118, col 29.
        write(''':&nbsp;</div></li>
<li><div class="plusclick navtab-''')
        if VFFSL(SL,"mode",True)==1 : # generated from line 119, col 34
            _v =  'active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  'inactive' 
            if _v is not None: write(_filter(_v))
        write('''" data-day="101">''')
        _v = VFFSL(SL,"tstrings",True)['tv_guide'] # "$tstrings['tv_guide']" on line 119, col 95
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['tv_guide']")) # from line 119, col 95.
        write('''</div></li>
<li><div class="plusclick navtab-''')
        if VFFSL(SL,"mode",True)==2 : # generated from line 120, col 34
            _v =  'active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  'inactive' 
            if _v is not None: write(_filter(_v))
        write('''" data-day="102">''')
        _v = VFFSL(SL,"tstrings",True)['timeline'] # "$tstrings['timeline']" on line 120, col 95
        if _v is not None: write(_filter(_v, rawExpr="$tstrings['timeline']")) # from line 120, col 95.
        write('''</div></li>
</ul>

<div id="compressmepg" onclick="CompressMEPG();"><i id="compressmepgi" class="fa fa-compress link" aria-hidden="true"></i></div>
<div id="refreshmepg2" onclick="RefreshMEPG();"><i id="refreshmepgi" class="fa fa-refresh link" aria-hidden="true"></i></div>
\t<br clear="all">

<ul class="nav nav-tabs tab--skinned" style="margin-top: -10px;">
''')
        for bq in VFFSL(SL,"bouquets",True): # generated from line 128, col 1
            write('''\t<li><div class="bq navtab-''')
            if VFFSL(SL,"bq",True)[0]==VFFSL(SL,"bref",True) : # generated from line 129, col 28
                _v =  'active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  'inactive' 
                if _v is not None: write(_filter(_v))
            write('''" data-ref="''')
            _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bq",True)[0]) # '$quote($bq[0])' on line 129, col 89
            if _v is not None: write(_filter(_v, rawExpr='$quote($bq[0])')) # from line 129, col 89.
            write('''">''')
            _v = VFFSL(SL,"bq",True)[1] # '$bq[1]' on line 129, col 105
            if _v is not None: write(_filter(_v, rawExpr='$bq[1]')) # from line 129, col 105.
            write('''</div></li>
''')
        write('''</ul>
<br clear="all">
</div>

''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 135, col 1
            write('''<style>
\t.picon { display: inline-block; margin:0; max-width: 100px;}
\t.picon > img { max-height: 30px;}
\t.timetable { border:none; height: 0px;}
\t.timetable > div { display:table; margin:0px 0px 0px -110px; padding:0;}
\t.timetable-now { position: relative;top: 0;left: 0px;z-index: 1;width: 2px;background-color: #0fb8fb;float:left;}
\t#tbl1 tbody { width: 100%; height: 100%; overflow-y: auto; display: block; overflow-x: hidden;}
\t.eventlist { display: inline-block; list-style-type: none; margin: 0px; padding: 0px 0px; width: calc(100% - 105px); }
\t.event { display: block; position: relative; vertical-align: top; clear: left; border: none; }
\t.event a,.event > span { padding: 0px; height:58px; width:100%; display: block; white-space: normal; overflow: hidden; }
\t.event a:link:hover { text-decoration: none; }
\t.ename { display: block; width: 100%; padding-left:5px; padding-top:10px; float: left; font-weight: 200; line-height: 1,4; font-size: 14px; }
\t.etime,.etimer  { display: inline-block; padding-left: 5px; font-weight: 200; line-height: 1,4; font-size: 12px; }
\t.event { display: inline-block; border:solid; border-width: 0px 0px 0px 1px; padding: 0px 0px 0px 0px!important; margin:0px 0px 0px -3px!important;}
\t.event .ename,.event .etime,.event .etimer { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
\t.channel-listing { list-style-type: none;}
\t.curevent { background: #e9e9e9; }
\t.etimesmall, .etime, .ename {
\t\tcolor: #000000;
\t\ttext-decoration: none;
\t}
\t.etimesmall, .etime {
\t\tfont-size: 10px;
\t}
\t.theme--city-lights .event a {
\t\tcolor: inherit;
\t}
\t.theme--city-lights .event a:hover {
\t\tcolor: inherit;
\t}
\t.theme--city-lights .curevent {
\t\tcolor: #f1f1f1;
\t\tbackground: #313443;
\t}
\t.theme--city-lights .ename,
\t.theme--city-lights .etimesmall, 
\t.theme--city-lights .etime { 
\t\tcolor: inherit;
\t}
</style>

''')
            now = VFFSL(SL,"mktime",False)(VFFSL(SL,"localtime",False)())
            write('''
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 179, col 1
                first = VFFSL(SL,"now",True) - 3600
            else: # generated from line 181, col 1
                first = VFFSL(SL,"now",True) + (VFFSL(SL,"day",True) * 3600 * 24)
            write('''
''')
            s = VFFSL(SL,"strftime",False)("%S",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            m = VFFSL(SL,"strftime",False)("%M",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            offset = VFFSL(SL,"int",False)(VFFSL(SL,"m",True)) * 60
            offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"s",True))
            write('''
''')
            if VFFSL(SL,"day",True) > 0: # generated from line 190, col 1
                h = VFFSL(SL,"strftime",False)("%H",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
                offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"h",True)) * 60 * 60
                offset = VFFSL(SL,"offset",True) + 3600
            write('''
''')
            first = VFFSL(SL,"first",True) - VFFSL(SL,"offset",True)
            write('''
''')
        write('''
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 200, col 1
            renderEventBlock = VFFSL(SL,"renderEvtBlock",False)()
            write('''<div id="fulltbl" class="responsive-table">
\t<table border="0" cellpadding="0" cellspacing="0" width="100%" id="tbl2">
\t\t<tbody id="tbl2body">
\t\t\t<tr style="background-color:#bababa;">
''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 206, col 1
                evl = VFFSL(SL,"eventlist",True)[0]
                ref = ""
                if VFFSL(SL,"evl",True): # generated from line 209, col 1
                    ev = VFFSL(SL,"evl",True)[0]
                    ref = "data-ref='" + VFFSL(SL,"ev.ref",True) + "'"
                write('''\t\t\t\t<td class="serviceheader">
\t\t\t\t\t<div class="service event" ''')
                _v = VFFSL(SL,"ref",True) # '$ref' on line 214, col 33
                if _v is not None: write(_filter(_v, rawExpr='$ref')) # from line 214, col 33.
                write('''><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # '$(picons[$sname])' on line 214, col 48
                if _v is not None: write(_filter(_v, rawExpr='$(picons[$sname])')) # from line 214, col 48.
                write('''" loading="lazy">''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 214, col 82
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 214, col 82.
                write('''</div>
\t\t\t\t</td>
''')
            write('''\t\t\t</tr>
\t\t\t<tr>
\t\t\t\t\t<table border="0" cellpadding="0" cellspacing="0" width="100%" id="tbl1" class="table table-striped">
\t\t\t\t\t\t<tbody id="tbl1body">
''')
            even = 0
            for slot in list(range(0,12)): # generated from line 222, col 1
                write('''\t\t\t\t\t\t\t<tr>
''')
                for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 224, col 2
                    write('''\t\t\t\t\t\t\t\t<td class="border" style="white-space:normal;">
''')
                    for event in VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]: # generated from line 226, col 3
                        write('''\t\t\t''')
                        _v = VFN(VFFSL(SL,"renderEventBlock",True),"render",False)(VFFSL(SL,"event",True)) # '$renderEventBlock.render($event)' on line 227, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$renderEventBlock.render($event)')) # from line 227, col 4.
                        write('''
''')
                    if len(VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]) == 0: # generated from line 229, col 3
                        write('''\t\t\t\t\t\t\t\t\t<article class="epg__event event"></article>
''')
                    write('''\t\t\t\t\t\t\t\t</td>
''')
                write('''\t\t\t\t\t\t\t</tr>
''')
            write('''\t\t\t\t\t\t</tbody>
\t\t\t\t\t</table>
\t\t\t</tr>
\t\t</tbody>
\t<table>
</div>

''')
        else: # generated from line 243, col 1
            write('''<div id="fulltbl" class="responsive-table" style="overflow-y:auto;overflow-x:hidden">
\t<table>
\t\t<tbody>
\t\t\t<tr>
\t\t\t\t<td>
\t\t\t\t\t<table>
\t\t\t\t\t\t<tbody>
\t\t\t\t\t\t\t<tr>
\t\t\t\t\t\t\t\t<td>
''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 253, col 1
                write('''\t\t\t\t\t\t\t\t\t<div class="row epg__row">
\t\t\t\t\t\t\t\t\t\t<div class="epg__channel pull-left">
\t\t\t\t\t\t\t\t\t\t\t<h2 class="picon"><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # '$(picons[$sname])' on line 256, col 40
                if _v is not None: write(_filter(_v, rawExpr='$(picons[$sname])')) # from line 256, col 40.
                write('''" title="''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 256, col 66
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 256, col 66.
                write('''" loading="lazy"></h2>
\t\t\t\t\t\t\t\t\t\t\t</br><label>''')
                _v = VFFSL(SL,"channelnames",True)[VFFSL(SL,"sname",True)] # '$(channelnames[$sname])' on line 257, col 24
                if _v is not None: write(_filter(_v, rawExpr='$(channelnames[$sname])')) # from line 257, col 24.
                write('''</label>
\t\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t\t</div>
''')
            write('''\t\t\t\t\t\t\t\t</td>
\t\t\t\t\t\t\t<tr>
\t\t\t\t\t\t<tbody>
\t\t\t\t\t</table>
\t\t\t\t</td>
\t\t\t\t<td>
\t\t\t\t\t<table class="table-striped">
\t\t\t\t\t\t<tbody>
\t\t\t\t\t\t\t<tr style="background-color: initial;">
\t\t\t\t\t\t\t\t<td>
\t\t\t\t\t\t\t\t\t<div style="overflow:auto" id="tblinner">
\t\t\t\t\t\t\t\t\t\t<div class="timetable">
\t\t\t\t\t\t\t\t\t\t\t<div>
\t\t\t\t\t\t\t\t\t\t\t\t<div class="timetable-now"></div>
\t\t\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t\t\t</div>
''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 277, col 1
                write('''\t\t\t\t\t\t\t\t\t\t<div class="row" style="width:30000px;border:solid;border-width:1px 0px 0px 0px;height:60px !important;">
\t\t\t\t\t\t\t\t\t\t\t<ol class="eventlist">
''')
                c = 0
                ref = ''
                for event in VFFSL(SL,"eventlist",True)[0]: # generated from line 282, col 2
                    pad = 0
                    if VFFSL(SL,"c",True) == 0: # generated from line 284, col 3
                        ref = quote(event['ref'], safe=' ~@#$&()*!+=:;,.?/\'')
                        pad = 58 + (VFFSL(SL,"event.begin_timestamp",True) - VFFSL(SL,"first",True)) / 6
                        write('''\t\t\t\t\t\t\t\t\t\t\t\t<li class="event" style="width:''')
                        _v = VFFSL(SL,"pad",True) # '${pad}' on line 287, col 44
                        if _v is not None: write(_filter(_v, rawExpr='${pad}')) # from line 287, col 44.
                        write('''px;border:none;">
\t\t\t\t\t\t\t\t\t\t\t\t</li>
''')
                    end = VFFSL(SL,"event.begin_timestamp",True) + VFFSL(SL,"event.duration",True)
                    iscurr = ""
                    if VFFSL(SL,"event.begin_timestamp",True) < VFFSL(SL,"now",True) and VFFSL(SL,"end",True) > VFFSL(SL,"now",True): # generated from line 292, col 3
                        iscurr = " curevent"
                    write('''\t\t\t\t\t\t\t\t\t\t\t\t<li class="event" data-ref="''')
                    _v = VFFSL(SL,"ref",True) # '$ref' on line 295, col 41
                    if _v is not None: write(_filter(_v, rawExpr='$ref')) # from line 295, col 41.
                    write('''" data-id="''')
                    _v = VFFSL(SL,"event.id",True) # '${event.id}' on line 295, col 56
                    if _v is not None: write(_filter(_v, rawExpr='${event.id}')) # from line 295, col 56.
                    write('''" data-toggle="modal" data-target="#EventModal" onclick="loadeventepg(\'''')
                    _v = VFFSL(SL,"event.id",True) # '${event.id}' on line 295, col 138
                    if _v is not None: write(_filter(_v, rawExpr='${event.id}')) # from line 295, col 138.
                    write("""', '""")
                    _v = VFFSL(SL,"ref",True) # '$ref' on line 295, col 153
                    if _v is not None: write(_filter(_v, rawExpr='$ref')) # from line 295, col 153.
                    write('''\');return false;" style="width:''')
                    _v = VFFSL(SL,"event.duration",True)/6 # '${event.duration/6}' on line 295, col 188
                    if _v is not None: write(_filter(_v, rawExpr='${event.duration/6}')) # from line 295, col 188.
                    write('''px;padding:10px;">
\t\t\t\t\t\t\t\t\t\t\t\t\t<a href="javascript:void(0);" class="ui-widget-content ''')
                    _v = VFFSL(SL,"iscurr",True) # '${iscurr}' on line 296, col 69
                    if _v is not None: write(_filter(_v, rawExpr='${iscurr}')) # from line 296, col 69.
                    write('''" title="''')
                    _v = VFFSL(SL,"event",True)['title'] # "$event['title']" on line 296, col 87
                    if _v is not None: write(_filter(_v, rawExpr="$event['title']")) # from line 296, col 87.
                    write('''">
\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span class="ename">''')
                    _v = VFFSL(SL,"event",True)['title'] # "$event['title']" on line 297, col 35
                    if _v is not None: write(_filter(_v, rawExpr="$event['title']")) # from line 297, col 35.
                    write('''<span class="etimesmall"> (''')
                    _v = VFFSL(SL,"strftime",False)("%d.%m", VFFSL(SL,"localtime",False)(VFFSL(SL,"event",True)['begin_timestamp'])) # '$strftime("%d.%m", $localtime($event[\'begin_timestamp\']))' on line 297, col 77
                    if _v is not None: write(_filter(_v, rawExpr='$strftime("%d.%m", $localtime($event[\'begin_timestamp\']))')) # from line 297, col 77.
                    write(''')</span></span>
\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span class="etime">''')
                    _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"event",True)['begin_timestamp'])) # '$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))' on line 298, col 35
                    if _v is not None: write(_filter(_v, rawExpr='$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))')) # from line 298, col 35.
                    write(''' - ''')
                    _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"event",True)['begin_timestamp'] + VFFSL(SL,"event",True)['duration'])) # '$strftime("%H:%M", $localtime($event[\'begin_timestamp\'] + $event[\'duration\']))' on line 298, col 95
                    if _v is not None: write(_filter(_v, rawExpr='$strftime("%H:%M", $localtime($event[\'begin_timestamp\'] + $event[\'duration\']))')) # from line 298, col 95.
                    write('''</span>
''')
                    if VFFSL(SL,"event",True)['timerStatus'] != '': # generated from line 299, col 4
                        write('''\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span class="etimer ''')
                        _v = VFFSL(SL,"event",True)['timerStatus'] # "$event['timerStatus']" on line 300, col 35
                        if _v is not None: write(_filter(_v, rawExpr="$event['timerStatus']")) # from line 300, col 35.
                        write('''">''')
                        _v = VFFSL(SL,"tstrings",True)['timer'] # "$tstrings['timer']" on line 300, col 58
                        if _v is not None: write(_filter(_v, rawExpr="$tstrings['timer']")) # from line 300, col 58.
                        write('''</span>
''')
                    write('''\t\t\t\t\t\t\t\t\t\t\t\t\t</a>
\t\t\t\t\t\t\t\t\t\t\t\t</li>
''')
                    c = VFFSL(SL,"c",True) + 1
                write('''\t\t\t\t\t\t\t\t\t\t\t</ol>
\t\t\t\t\t\t\t\t\t\t</div>
''')
            write('''\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t</td>
\t\t\t\t\t\t\t<tr>
\t\t\t\t\t\t</tbody>
\t\t\t\t\t</table>
\t\t\t\t\t
\t\t\t\t</td>
\t\t\t<tr>
\t\t</tbody>
\t<table>
</div>
</div>

</div>
''')
        write('''<div id="eventdescription"></div>

<script>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 327, col 1
            write('''var opena = ''')
            _v = VFFSL(SL,"first",True) # '$first' on line 328, col 13
            if _v is not None: write(_filter(_v, rawExpr='$first')) # from line 328, col 13.
            write(''';
var openb = ''')
            _v = VFFSL(SL,"now",True) # '$now' on line 329, col 13
            if _v is not None: write(_filter(_v, rawExpr='$now')) # from line 329, col 13.
            write(''';
var pos = (openb - opena);
if (pos > 0)
\tpos = pos / 6;

''')
            if VFFSL(SL,"day",True) == 0: # generated from line 334, col 1
                write('''
jQuery(".timetable-now").css(\'left\',151 + pos);

setTimeout(function() {
\tvar nowdate = Math.round(+new Date()/1000);
\tvar pos = (nowdate - opena);
\tif(pos > 0)
\t\tpos = pos / 6;
\tjQuery(".timetable-now").css(\'left\',151 + pos);
} ,10000);

jQuery(".timetable-now").css(\'height\', jQuery("#tblinner").height());
''')
            else: # generated from line 347, col 1
                write('''jQuery(".timetable-now").css(\'height\', \'0\');
''')
            write('''
''')
        write('''var picons = ''')
        _v = VFFSL(SL,"dumps",False)(VFFSL(SL,"picons",True)) # '$dumps($picons)' on line 352, col 14
        if _v is not None: write(_filter(_v, rawExpr='$dumps($picons)')) # from line 352, col 14.
        write(''';
var reloadTimers = false;
function getScrollBarWidth () {
\tvar outer = jQuery(\'<div>\').css({visibility: \'hidden\', width: 100, overflow: \'scroll\'}).appendTo(\'body\'),
\t\twidthWithScroll = jQuery(\'<div>\').css({width: \'100%\'}).appendTo(outer).outerWidth();
\touter.remove();
\treturn 100 - widthWithScroll;
}
var scrollBarWidth=getScrollBarWidth();
function fixTableHeight() {
\tvar addScrollBarWidth = scrollBarWidth;
\tif (jQuery(\'#tbl1\').width() <= jQuery("#tvcontent").width()){
\t\taddScrollBarWidth = 0;
\t}

''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 367, col 1
            write('''\tvar new_height = (jQuery("#epgcard").height() *0.85 - jQuery("#epgcardheaderI").height() - jQuery("#epgcardheaderII").height() - jQuery("#navepg").height() - 2*jQuery("#tbl1 thead").height() - addScrollBarWidth - 2);
\tjQuery("#tbl1body").height(new_height + "px");
\tvar scrollwidth = (jQuery("#epgcard").width() -40 ) + "px";
\tvar scrollheightI = new_height + \'px\';
\tjQuery(\'#tbl1body\').height(scrollheightI);
\tjQuery(\'#fulltbl\').width(scrollwidth);

\tjQuery("#fulltbl").height((jQuery("#leftsidemenu").height() - 300) + "px");
''')
        else: # generated from line 376, col 1
            write('''\tvar new_height = (jQuery("#epgcard").height() *0.90 - jQuery("#epgcardheaderI").height() - jQuery("#epgcardheaderII").height() - jQuery("#navepg").height() - 2*jQuery("#tbl1 thead").height() - addScrollBarWidth - 2);
\tvar scrollheightI = new_height + \'px\';
\tvar scrollwidth = (jQuery("#epgcard").width() -40 ) + "px";
\tjQuery(\'#fulltbl\').height(scrollheightI);
\tjQuery(\'#tblinner\').width(scrollwidth);
''')
        write('''}
fixTableHeight();

jQuery(window).resize(function(){ fixTableHeight(); });

jQuery(".bq").click(function() {
\tvar id = jQuery(this).data("ref");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # '$epgmode' on line 390, col 17
        if _v is not None: write(_filter(_v, rawExpr='$epgmode')) # from line 390, col 17.
        write('''";
\tjQuery("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=\'+id +\'&day=''')
        _v = VFFSL(SL,"day",True) # '$day' on line 391, col 78
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 391, col 78.
        write('''&epgmode=\' + epgmode);
\tSetLSValue("lastmbq_"+epgmode,id);
});

''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 395, col 1
            write('''jQuery(".service").click(function() {
\tvar ref = jQuery(this).data("ref");
\tif (ref != undefined) {
\t\tzapChannel(ref, \'\');
\t}
});
''')
        write('''jQuery(".plusclick").click(function() {
\tvar day = jQuery(this).data("day");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # '$epgmode' on line 405, col 17
        if _v is not None: write(_filter(_v, rawExpr='$epgmode')) # from line 405, col 17.
        write('''";
\tif (day != undefined) {
\t\tif (day > 999)
\t\t{
\t\t\tvar w = day - 1000;
\t\t\tjQuery("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 410, col 68
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 410, col 68.
        write("""&day='+""")
        _v = VFFSL(SL,"day",True) # '$day' on line 410, col 90
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 410, col 90.
        write('''+\'&epgmode=\'+epgmode+\'&week=\'+w);
\t\t}
\t\telse if (day > 199)
\t\t{
\t\t\tvar d = day - 200;
\t\t\tvar dt = (d==0) ? \'\' : jQuery(this).html();
\t\t\tvar pos = 0;
\t\t\tjQuery(\'#tblinner\').scrollLeft(0);
\t\t\tjQuery("#timescroller li ol .event").each( function (){
\t\t\t\tif (pos == 0) {
\t\t\t\t\tif (jQuery(this).data("dt") == dt) {
\t\t\t\t\t\tif(jQuery(this).position() != undefined)
\t\t\t\t\t\t\tpos = jQuery(this).position().left;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t});
\t\t\t
\t\t\tif(d==\'\')
\t\t\t{
\t\t\t\tvar l = jQuery(".timetable-now").css(\'left\');
\t\t\t\tpos = parseInt(l.replace(\'px\',\'\'));
\t\t\t}

\t\t\tif(pos>0)
\t\t\t{
\t\t\t\tpos-=200;
\t\t\t\t
\t\t\t\tjQuery(\'#tbl1body\').animate({scrollLeft: pos}, 500);
\t\t\t\t
\t\t\t\t 
\t\t\t}
\t\t}
\t\telse if (day > 100)
\t\t{
\t\t\tvar mode = day - 100;
\t\t\tif (mode != ''')
        _v = VFFSL(SL,"mode",True) # '$mode' on line 445, col 16
        if _v is not None: write(_filter(_v, rawExpr='$mode')) # from line 445, col 16.
        write(''') {
\t\t\t\tjQuery.ajax({
\t\t\t\turl: \'api/setwebconfig?mepgmode=\' + mode,
\t\t\t\t\tsuccess: function(data) {
\t\t\t\t\t\tjQuery("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 449, col 71
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 449, col 71.
        write('''&day=''')
        _v = VFFSL(SL,"day",True) # '$day' on line 449, col 91
        if _v is not None: write(_filter(_v, rawExpr='$day')) # from line 449, col 91.
        write("""&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # '$week' on line 449, col 123
        if _v is not None: write(_filter(_v, rawExpr='$week')) # from line 449, col 123.
        write(''');
\t\t\t\t\t}
\t\t\t\t});
\t\t\t}
\t\t}
\t\telse {
\t\t\tjQuery("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # '${quote($bref)}' on line 455, col 68
        if _v is not None: write(_filter(_v, rawExpr='${quote($bref)}')) # from line 455, col 68.
        write("""&day='+day+'&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # '$week' on line 455, col 123
        if _v is not None: write(_filter(_v, rawExpr='$week')) # from line 455, col 123.
        write(''');
\t\t}
\t} else {
\t\tepgmode = jQuery(this).data("tvradio");
\t\tif (epgmode != undefined) {
\t\t\tjQuery("#tvcontent").html(loadspinner).load(\'ajax/multiepg?day=\'+day+\'&epgmode=\'+epgmode);
\t\t}
\t}
});

\tif (jQuery("#header").is(\':hidden\')) { 
\t\tjQuery(\'#compressmepg\').show();
\t\tjQuery(\'#refreshmepg2\').show();
\t}
\tif (mepgdirect == 1) {
\t\tmepgdirect=0;
\t\tjQuery("#expandmepg").click();
\t}
\tjQuery(".togglescroll").click(function() {
\t\tif(jQuery(\'#tblinner\').css(\'overflow-y\') == \'hidden\') {
\t\t\tjQuery(\'#tblinner\').css(\'overflow-y\', \'\');
\t\t\tjQuery(\'.togglescroll\').removeClass(\'ui-widget-header\');
\t\t\tSetLSValue(\'MultiEPGScrollStyle\', \'1\');
\t\t} else {
\t\t\tjQuery(\'#tblinner\').css(\'overflow-y\', \'hidden\');
\t\t\tjQuery(\'.togglescroll\').addClass(\'ui-widget-header\');
\t\t\tSetLSValue(\'MultiEPGScrollStyle\', \'0\');
\t\t}
\t});

''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 485, col 1
            write("""\tjQuery(function() {
\t\tif (GetLSValue('MultiEPGScrollStyle', '0')=='0') {
\t\t\tjQuery('#tblinner').css('overflow-y', 'hidden');
\t\t\tjQuery('.togglescroll').addClass('ui-widget-header');
\t\t} else {
\t\t\tjQuery('#tblinner').css('overflow-y', '');
\t\t\tjQuery('.togglescroll').removeClass('ui-widget-header');
\t\t}
\t});
""")
        write('''
</script>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_multiepg = 'respond'

## END CLASS DEFINITION

if not hasattr(multiepg, '_initCheetahAttributes'):
    templateAPIClass = getattr(multiepg,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(multiepg)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=multiepg()).run()


