#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from six.moves.urllib.parse import quote
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings
from Plugins.Extensions.OpenWebif.vtiaddon import MinMovieList

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.3.3'
__CHEETAH_versionTuple__ = (3, 3, 3, 'final', 0)
__CHEETAH_genTime__ = 1704536007.8223722
__CHEETAH_genTimestamp__ = 'Sat Jan  6 10:13:27 2024'
__CHEETAH_src__ = '/media/daimon/61c88a30-8b91-4a81-8b0a-975af139a961/dream/build/tmp/work/dm920-oe-linux-gnueabi/enigma2-plugin-extensions-openwebif/git/git/plugin/controllers/views/responsive/ajax/moviesearch.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Jan  6 09:24:27 2024'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class moviesearch(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(moviesearch, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        if VFFSL(SL,"MinMovieList",True) == 'checked': # generated from line 5, col 1
            write('''
\t<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
\t\t<div class="card">
\t\t\t<div class="header">
\t\t\t\t<div class="row clearfix">
\t\t\t\t\t<div class="col-xs-12 col-sm-6">
\t\t\t\t\t\t<h2><i class="material-icons material-icons-centered">movie</i>''')
            _v = VFFSL(SL,"tstrings",True)['movies'] # "$tstrings['movies']" on line 12, col 70
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['movies']")) # from line 12, col 70.
            write('''</h2>
\t\t\t\t\t</div>
\t\t\t\t</div>
\t\t\t\t<ul class="header-dropdown">
\t\t\t\t\t<li>
\t\t\t\t\t\t<li class="dropdown"><li class="dropdown"><a href="javascript:void(0);" onclick="lastcontenturl = \'\\\'; load_maincontent_spin(\'ajax/movies\'); return false;" ><i class="material-icons">autorenew</i></a>
\t\t\t\t\t\t<a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="material-icons">more_vert</i></a>
\t\t\t\t\t\t<ul class="dropdown-menu pull-right" id="timerbuttons">
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'name\'); return false" ><i class="material-icons material-icons-centered">vertical_align_bottom</i>''')
            _v = VFFSL(SL,"tstrings",True)['name'] # "$tstrings['name']" on line 20, col 171
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['name']")) # from line 20, col 171.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'named\'); return false" ><i class="material-icons material-icons-centered">vertical_align_top</i>''')
            _v = VFFSL(SL,"tstrings",True)['name'] # "$tstrings['name']" on line 21, col 169
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['name']")) # from line 21, col 169.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'date\'); return false" ><i class="material-icons material-icons-centered">vertical_align_bottom</i>''')
            _v = VFFSL(SL,"tstrings",True)['date'] # "$tstrings['date']" on line 22, col 171
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['date']")) # from line 22, col 171.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'dated\'); return false" ><i class="material-icons material-icons-centered">vertical_align_top</i>''')
            _v = VFFSL(SL,"tstrings",True)['date'] # "$tstrings['date']" on line 23, col 169
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['date']")) # from line 23, col 169.
            write('''</a></li>
\t\t\t\t\t\t</ul>
\t\t\t\t\t</li>
\t\t\t\t</ul>
\t\t\t\t</div>
\t\t\t\t<div class="body">
\t\t\t\t<div id="content_main">
\t\t\t\t<div id="tvcontentmain">

''')
            path = ''
            write('''\t<div class="row clearfix">
\t\t<div class="col-xs-12" id="movies">
\t
''')
            count = 0
            for movie in VFFSL(SL,"movies",True): # generated from line 37, col 2
                write('''
\t<div class="row row-striped clearfix pad-top-15">
\t\t<div class="col-xs-12 col-md-6">
\t
''')
                if VFFSL(SL,"movie.descriptionExtended",True) == '': # generated from line 42, col 2
                    if VFFSL(SL,"movie.eventname",True) != '': # generated from line 43, col 3
                        write('''\t\t\t<b><i class="material-icons material-icons-centered">movie</i>
\t\t\t''')
                        _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 45, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 45, col 4.
                        write(''' - ''')
                        _v = VFFSL(SL,"movie.servicename",True) # '$movie.servicename' on line 45, col 23
                        if _v is not None: write(_filter(_v, rawExpr='$movie.servicename')) # from line 45, col 23.
                        write('''</b>
\t\t\t<span data-toggle="collapse" data-target="#eventid''')
                        _v = VFFSL(SL,"count",True) # '$count' on line 46, col 54
                        if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 46, col 54.
                        write('''" aria-expanded="false"aria-controls="collapseExample" style="cursor:pointer;"><b>
\t\t\t''')
                        _v = VFFSL(SL,"movie.description",True) # '$movie.description' on line 47, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.description')) # from line 47, col 4.
                        write('''</b><i class="material-icons material-icons-centered">expand_more</i></span>
''')
                    else: # generated from line 48, col 3
                        write('''\t\t\t<b><i class="material-icons material-icons-centered">movie</i>
\t\t\t''')
                        _v = VFFSL(SL,"movie.filename",True) # '$movie.filename' on line 50, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.filename')) # from line 50, col 4.
                        write('''</b>
\t\t\t<span data-toggle="collapse" data-target="#eventid''')
                        _v = VFFSL(SL,"count",True) # '$count' on line 51, col 54
                        if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 51, col 54.
                        write('''" aria-expanded="false"aria-controls="collapseExample" style="cursor:pointer;"><b>
\t\t\t''')
                        _v = VFFSL(SL,"movie.description",True) # '$movie.description' on line 52, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.description')) # from line 52, col 4.
                        write('''</b><i class="material-icons material-icons-centered">expand_more</i></span>
''')
                elif VFFSL(SL,"movie.eventname",True) != '': # generated from line 54, col 2
                    write('''\t\t<b><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 55, col 65
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 55, col 65.
                    write(''' - ''')
                    _v = VFFSL(SL,"movie.servicename",True) # '$movie.servicename' on line 55, col 84
                    if _v is not None: write(_filter(_v, rawExpr='$movie.servicename')) # from line 55, col 84.
                    write('''</b>
''')
                else: # generated from line 56, col 2
                    write('''\t\t<b><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.filename",True) # '$movie.filename' on line 57, col 65
                    if _v is not None: write(_filter(_v, rawExpr='$movie.filename')) # from line 57, col 65.
                    write('''</b>
''')
                write('''\t</div>
\t<div class="col-xs-12 col-md-3">
''')
                if VFFSL(SL,"movie.eventname",True) != '': # generated from line 61, col 2
                    da = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(VFFSL(SL,"movie.recordingtime",True)))))]
                    write('''\t\t<span>''')
                    _v = VFFSL(SL,"da",True) # '$da' on line 63, col 9
                    if _v is not None: write(_filter(_v, rawExpr='$da')) # from line 63, col 9.
                    write('''. ''')
                    _v = VFFSL(SL,"movie.begintime",True) # '$movie.begintime' on line 63, col 14
                    if _v is not None: write(_filter(_v, rawExpr='$movie.begintime')) # from line 63, col 14.
                    write(''' | ''')
                    _v = VFFSL(SL,"movie.length",True) # '$movie.length' on line 63, col 33
                    if _v is not None: write(_filter(_v, rawExpr='$movie.length')) # from line 63, col 33.
                    write(''' min. / ''')
                    _v = VFFSL(SL,"movie.filesize_readable",True) # '$movie.filesize_readable' on line 63, col 54
                    if _v is not None: write(_filter(_v, rawExpr='$movie.filesize_readable')) # from line 63, col 54.
                    write('''</span>
''')
                write('''\t</div>
\t<div class="col-xs-12 col-md-3 align-right">
\t
\t\t<a href="javascript:void(0);" class="link--skinned" onclick="playRecording(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 68, col 79
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 68, col 79.
                write('''\');" title="''')
                _v = VFFSL(SL,"tstrings",True)['playback'] # "$tstrings['playback']" on line 68, col 116
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['playback']")) # from line 68, col 116.
                write('''"><i class="material-icons material-icons-centered">play_circle_outline</i></a>
''')
                if VFFSL(SL,"transcoding",True): # generated from line 69, col 3
                    write('''\t\t<a href="javascript:void(0);" class="link--skinned" onclick="jumper80(\'''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 70, col 74
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 70, col 74.
                    write('''\');" title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 70, col 109
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 70, col 109.
                    write(''': ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 70, col 130
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 70, col 130.
                    write('''"><i class="material-icons material-icons-centered">tv</i></a>
\t\t<a href="javascript:void(0);" class="link--skinned" onclick="jumper8003(\'''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 71, col 76
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 71, col 76.
                    write('''\');" title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 71, col 111
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 71, col 111.
                    write(''' (''')
                    _v = VFFSL(SL,"tstrings",True)['transcoded'] # "$tstrings['transcoded']" on line 71, col 132
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['transcoded']")) # from line 71, col 132.
                    write('''): ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 71, col 158
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 71, col 158.
                    write('''"><i class="material-icons material-icons-centered">phone_android</i></a>
''')
                else: # generated from line 72, col 3
                    write('''\t\t<a href="web/ts.m3u?file=''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 73, col 28
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 73, col 28.
                    write('''" class="link--skinned" title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 73, col 82
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 73, col 82.
                    write(''' ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 73, col 102
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 73, col 102.
                    write('''" target="_blank"><i class="material-icons material-icons-centered">tv</i></a>
''')
                write('''\t\t
''')
                eventname_escaped = VFN(VFFSL(SL,"movie.eventname",True),"replace",False)("'", r"\'")
                write('''\t\t<a href="/file?action=download&file=''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 77, col 39
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 77, col 39.
                write('''" class="link--skinned" title="''')
                _v = VFFSL(SL,"tstrings",True)['download'] # "$tstrings['download']" on line 77, col 93
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['download']")) # from line 77, col 93.
                write(''' ''')
                _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 77, col 115
                if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 77, col 115.
                write('''"><i class="material-icons material-icons-centered">cloud_download</i></a>
\t\t<a href="javascript:void(0);" class="link--skinned" onclick="renameMovie(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 78, col 77
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 78, col 77.
                write("""','""")
                _v = VFFSL(SL,"eventname_escaped",True) # '$eventname_escaped' on line 78, col 105
                if _v is not None: write(_filter(_v, rawExpr='$eventname_escaped')) # from line 78, col 105.
                write('''\');" title="''')
                _v = VFFSL(SL,"tstrings",True)['rename_recording'] # "$tstrings['rename_recording']" on line 78, col 135
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['rename_recording']")) # from line 78, col 135.
                write('''"><i class="material-icons material-icons-centered">edit</i></a>
\t\t<a href="javascript:void(0);" class="link--skinned" onclick="deleteMovie(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 79, col 77
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 79, col 77.
                write("""', '""")
                _v = VFFSL(SL,"count",True) # '$count' on line 79, col 106
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 79, col 106.
                write("""', '""")
                _v = VFFSL(SL,"eventname_escaped",True) # '$eventname_escaped' on line 79, col 116
                if _v is not None: write(_filter(_v, rawExpr='$eventname_escaped')) # from line 79, col 116.
                write('''\'); return false;" title="''')
                _v = VFFSL(SL,"tstrings",True)['delete_recording'] # "$tstrings['delete_recording']" on line 79, col 160
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['delete_recording']")) # from line 79, col 160.
                write('''"><i class="material-icons material-icons-centered">delete</i></a>
\t</div>
\t<div class="col-xs-12 collapse" id="eventid''')
                _v = VFFSL(SL,"count",True) # '$count' on line 81, col 45
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 81, col 45.
                write('''">
\t<p>''')
                _v = VFFSL(SL,"movie.descriptionExtended",True) # '$movie.descriptionExtended' on line 82, col 5
                if _v is not None: write(_filter(_v, rawExpr='$movie.descriptionExtended')) # from line 82, col 5.
                write('''</p>
\t</div></div>
''')
                count = VFFSL(SL,"count",True) + 1
            write('''\t\t\t</div>
\t\t</div>
\t</div>
</div>

</div></div></div>

''')
        else: # generated from line 93, col 1
            write('''\t<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
\t\t<div class="card">
\t\t\t<div class="header">
\t\t\t\t<div class="row clearfix">
\t\t\t\t\t<div class="col-xs-12 col-sm-6">
\t\t\t\t\t\t<h2><i class="material-icons material-icons-centered">movie</i>''')
            _v = VFFSL(SL,"tstrings",True)['movies'] # "$tstrings['movies']" on line 99, col 70
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['movies']")) # from line 99, col 70.
            write('''</h2>
\t\t\t\t\t</div>
\t\t\t\t</div>
\t\t\t\t<ul class="header-dropdown">
\t\t\t\t\t<li>
\t\t\t\t\t\t<li class="dropdown"><li class="dropdown"><a href="javascript:void(0);" onclick="lastcontenturl = \'\\\'; load_maincontent_spin(\'ajax/movies\'); return false;" ><i class="material-icons">autorenew</i></a>
\t\t\t\t\t\t<a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="material-icons">more_vert</i></a>
\t\t\t\t\t\t<ul class="dropdown-menu pull-right" id="timerbuttons">
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'name\'); return false" ><i class="material-icons material-icons-centered">vertical_align_bottom</i>''')
            _v = VFFSL(SL,"tstrings",True)['name'] # "$tstrings['name']" on line 107, col 171
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['name']")) # from line 107, col 171.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'named\'); return false" ><i class="material-icons material-icons-centered">vertical_align_top</i>''')
            _v = VFFSL(SL,"tstrings",True)['name'] # "$tstrings['name']" on line 108, col 169
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['name']")) # from line 108, col 169.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'date\'); return false" ><i class="material-icons material-icons-centered">vertical_align_bottom</i>''')
            _v = VFFSL(SL,"tstrings",True)['date'] # "$tstrings['date']" on line 109, col 171
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['date']")) # from line 109, col 171.
            write('''</a></li>
\t\t\t\t\t\t<li><a href="javascript:void(0);" onclick="changeMoviesortSearch(\'dated\'); return false" ><i class="material-icons material-icons-centered">vertical_align_top</i>''')
            _v = VFFSL(SL,"tstrings",True)['date'] # "$tstrings['date']" on line 110, col 169
            if _v is not None: write(_filter(_v, rawExpr="$tstrings['date']")) # from line 110, col 169.
            write('''</a></li>
\t\t\t\t\t\t</ul>
\t\t\t\t\t</li>
\t\t\t\t</ul>
\t\t\t\t</div>
\t\t\t\t<div class="body">
\t\t\t\t<div id="content_main">
\t\t\t\t<div id="tvcontentmain">
''')
            path = ''
            write('''\t<div class="row clearfix">
\t<div class="col-xs-12" id="movies">

''')
            count = 0
            for movie in VFFSL(SL,"movies",True): # generated from line 123, col 2
                write('''\t
\t<div class="card" id="''')
                _v = VFFSL(SL,"count",True) # '$count' on line 125, col 24
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 125, col 24.
                write('''">
\t<div class="header">
\t<div class="row clearfix">
\t<div class="col-xs-8">

''')
                if VFFSL(SL,"movie.eventname",True) != '': # generated from line 130, col 2
                    da = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(VFFSL(SL,"movie.recordingtime",True)))))]
                    write('''\t\t<span>''')
                    _v = VFFSL(SL,"da",True) # '$da' on line 132, col 9
                    if _v is not None: write(_filter(_v, rawExpr='$da')) # from line 132, col 9.
                    write('''. ''')
                    _v = VFFSL(SL,"movie.begintime",True) # '$movie.begintime' on line 132, col 14
                    if _v is not None: write(_filter(_v, rawExpr='$movie.begintime')) # from line 132, col 14.
                    write(''' | ''')
                    _v = VFFSL(SL,"movie.length",True) # '$movie.length' on line 132, col 33
                    if _v is not None: write(_filter(_v, rawExpr='$movie.length')) # from line 132, col 33.
                    write(''' min. / ''')
                    _v = VFFSL(SL,"movie.filesize_readable",True) # '$movie.filesize_readable' on line 132, col 54
                    if _v is not None: write(_filter(_v, rawExpr='$movie.filesize_readable')) # from line 132, col 54.
                    write('''</span>
''')
                write('''
''')
                if VFFSL(SL,"movie.descriptionExtended",True) == '': # generated from line 135, col 2
                    if VFFSL(SL,"movie.eventname",True) != '': # generated from line 136, col 3
                        write('''\t\t\t<b><i class="material-icons material-icons-centered">movie</i>
\t\t\t''')
                        _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 138, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 138, col 4.
                        write(''' - ''')
                        _v = VFFSL(SL,"movie.servicename",True) # '$movie.servicename' on line 138, col 23
                        if _v is not None: write(_filter(_v, rawExpr='$movie.servicename')) # from line 138, col 23.
                        write('''</b>
\t\t\t<span data-toggle="collapse" data-target="#eventid''')
                        _v = VFFSL(SL,"count",True) # '$count' on line 139, col 54
                        if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 139, col 54.
                        write('''" aria-expanded="false"aria-controls="collapseExample" style="cursor:pointer;"><b>
\t\t\t''')
                        _v = VFFSL(SL,"movie.description",True) # '$movie.description' on line 140, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.description')) # from line 140, col 4.
                        write('''</b><i class="material-icons material-icons-centered">expand_more</i></span>
''')
                    else: # generated from line 141, col 3
                        write('''\t\t\t<b><i class="material-icons material-icons-centered">movie</i>
\t\t\t''')
                        _v = VFFSL(SL,"movie.filename",True) # '$movie.filename' on line 143, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.filename')) # from line 143, col 4.
                        write('''</b>
\t\t\t<span data-toggle="collapse" data-target="#eventid''')
                        _v = VFFSL(SL,"count",True) # '$count' on line 144, col 54
                        if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 144, col 54.
                        write('''" aria-expanded="false"aria-controls="collapseExample" style="cursor:pointer;"><b>
\t\t\t''')
                        _v = VFFSL(SL,"movie.description",True) # '$movie.description' on line 145, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$movie.description')) # from line 145, col 4.
                        write('''</b><i class="material-icons material-icons-centered">expand_more</i></span>
''')
                elif VFFSL(SL,"movie.eventname",True) != '': # generated from line 147, col 2
                    write('''\t\t<b><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 148, col 65
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 148, col 65.
                    write(''' - ''')
                    _v = VFFSL(SL,"movie.servicename",True) # '$movie.servicename' on line 148, col 84
                    if _v is not None: write(_filter(_v, rawExpr='$movie.servicename')) # from line 148, col 84.
                    write('''</b>
''')
                else: # generated from line 149, col 2
                    write('''\t\t<b><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.filename",True) # '$movie.filename' on line 150, col 65
                    if _v is not None: write(_filter(_v, rawExpr='$movie.filename')) # from line 150, col 65.
                    write('''</b>
''')
                write('''\t</div>
\t<div class="col-xs-12 col-md-3">
''')
                if VFFSL(SL,"movie.eventname",True) != '': # generated from line 154, col 2
                    write('''\t\t<h2><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 155, col 66
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 155, col 66.
                    write(''' - ''')
                    _v = VFFSL(SL,"movie.servicename",True) # '$movie.servicename' on line 155, col 85
                    if _v is not None: write(_filter(_v, rawExpr='$movie.servicename')) # from line 155, col 85.
                    write('''</h2>
''')
                else: # generated from line 156, col 2
                    write('''\t\t<h2><i class="material-icons material-icons-centered">movie</i>''')
                    _v = VFFSL(SL,"movie.filename",True) # '$movie.filename' on line 157, col 66
                    if _v is not None: write(_filter(_v, rawExpr='$movie.filename')) # from line 157, col 66.
                    write('''</h2>
''')
                write('''\t</div>
\t<div class="col-xs-4">
\t<ul class="header-dropdown">
\t\t<li><span role="button"><a href=\'#\' onclick="playRecording(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 162, col 63
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 162, col 63.
                write('''\');" title="''')
                _v = VFFSL(SL,"tstrings",True)['playback'] # "$tstrings['playback']" on line 162, col 100
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['playback']")) # from line 162, col 100.
                write('''"><i class="material-icons material-icons-centered">play_circle_outline</i></a></span></li>
''')
                if VFFSL(SL,"transcoding",True): # generated from line 163, col 3
                    write('''\t\t<li><span role="button"><a href="javascript:void(0);" onclick="jumper80(\'''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 164, col 76
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 164, col 76.
                    write('''\');" title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 164, col 111
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 164, col 111.
                    write(''': ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 164, col 132
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 164, col 132.
                    write('''"><i class="material-icons material-icons-centered">tv</i></a></span></li>
\t\t<li><span role="button"><a href="javascript:void(0);" onclick="jumper8003(\'''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 165, col 78
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 165, col 78.
                    write('''\');" title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 165, col 113
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 165, col 113.
                    write(''' (''')
                    _v = VFFSL(SL,"tstrings",True)['transcoded'] # "$tstrings['transcoded']" on line 165, col 134
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['transcoded']")) # from line 165, col 134.
                    write('''): ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 165, col 160
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 165, col 160.
                    write('''"><i class="material-icons material-icons-centered">phone_android</i></a></span></li>
''')
                else: # generated from line 166, col 3
                    write('''\t\t<li><span role="button"><a target="_blank" href=\'web/ts.m3u?file=''')
                    _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 167, col 68
                    if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 167, col 68.
                    write('''\' title="''')
                    _v = VFFSL(SL,"tstrings",True)['stream'] # "$tstrings['stream']" on line 167, col 100
                    if _v is not None: write(_filter(_v, rawExpr="$tstrings['stream']")) # from line 167, col 100.
                    write(''' ''')
                    _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 167, col 120
                    if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 167, col 120.
                    write('''"><i class="material-icons material-icons-centered">tv</i></a></span></li>
''')
                write('''
''')
                eventname_escaped = VFN(VFFSL(SL,"movie.eventname",True),"replace",False)("'", r"\'")
                write('''\t\t<li><span role="button"><a href=\'/file?action=download&file=''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.filename",True)) # '$quote($movie.filename)' on line 171, col 63
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.filename)')) # from line 171, col 63.
                write('''\' title="''')
                _v = VFFSL(SL,"tstrings",True)['download'] # "$tstrings['download']" on line 171, col 95
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['download']")) # from line 171, col 95.
                write(''' ''')
                _v = VFFSL(SL,"movie.eventname",True) # '$movie.eventname' on line 171, col 117
                if _v is not None: write(_filter(_v, rawExpr='$movie.eventname')) # from line 171, col 117.
                write('''"><i class="material-icons material-icons-centered">cloud_download</i></a></span></li>
\t\t<li><span role="button"><a href=\'#\' onclick="renameMovie(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 172, col 61
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 172, col 61.
                write("""','""")
                _v = VFFSL(SL,"eventname_escaped",True) # '$eventname_escaped' on line 172, col 89
                if _v is not None: write(_filter(_v, rawExpr='$eventname_escaped')) # from line 172, col 89.
                write('''\');" title="''')
                _v = VFFSL(SL,"tstrings",True)['rename_recording'] # "$tstrings['rename_recording']" on line 172, col 119
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['rename_recording']")) # from line 172, col 119.
                write('''"><i class="material-icons material-icons-centered">edit</i></a></span></li>
\t\t<li><span role="button"><a href=\'#\' onclick="deleteMovie(\'''')
                _v = VFFSL(SL,"quote",False)(VFFSL(SL,"movie.serviceref",True)) # '$quote($movie.serviceref)' on line 173, col 61
                if _v is not None: write(_filter(_v, rawExpr='$quote($movie.serviceref)')) # from line 173, col 61.
                write("""', '""")
                _v = VFFSL(SL,"count",True) # '$count' on line 173, col 90
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 173, col 90.
                write("""', '""")
                _v = VFFSL(SL,"eventname_escaped",True) # '$eventname_escaped' on line 173, col 100
                if _v is not None: write(_filter(_v, rawExpr='$eventname_escaped')) # from line 173, col 100.
                write('''\'); return false;" title="''')
                _v = VFFSL(SL,"tstrings",True)['delete_recording'] # "$tstrings['delete_recording']" on line 173, col 144
                if _v is not None: write(_filter(_v, rawExpr="$tstrings['delete_recording']")) # from line 173, col 144.
                write('''"><i class="material-icons material-icons-centered">delete</i></a></span></li>
\t</ul>
\t</div></div>
<div class="row clearfix" style="margin-bottom:-25px;">
\t<div class="col-xs-8">
''')
                da = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(VFFSL(SL,"movie.recordingtime",True)))))]
                write('''\t\t\t<span>''')
                _v = VFFSL(SL,"da",True) # '$da' on line 179, col 10
                if _v is not None: write(_filter(_v, rawExpr='$da')) # from line 179, col 10.
                write('''</span>
''')
                w = VFFSL(SL,"movie.lastseen",True)
                size = '0'
                if VFFSL(SL,"w",True) > 0: # generated from line 182, col 5
                    w = VFFSL(SL,"w",True) * 70 / 100
                    size = str(VFFSL(SL,"w",True))
                    write('''\t\t\t\t\t<div class="ui-progressbar ui-corner-all ui-widget ui-widget-content">
\t\t\t\t\t\t<div class="ui-progressbar-value ui-corner-left ui-widget-header" style="width: ''')
                    _v = VFFSL(SL,"size",True) # '$size' on line 186, col 87
                    if _v is not None: write(_filter(_v, rawExpr='$size')) # from line 186, col 87.
                    write(''';"></div>
\t\t\t\t\t</div>
''')
                write('''\t\t\t\t<div class="progress progress-striped" style="margin-bottom:0px;width:35%;max-width:200px;min-width:100px;height:10px;">
\t\t\t\t\t<div class="progress-bar bg--skinned" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:''')
                _v = VFFSL(SL,"size",True) # '$size' on line 190, col 132
                if _v is not None: write(_filter(_v, rawExpr='$size')) # from line 190, col 132.
                write('''%;"></div>
\t\t\t\t</div>
\t\t\t\t<span>''')
                _v = VFFSL(SL,"movie.length",True) # '$movie.length' on line 192, col 11
                if _v is not None: write(_filter(_v, rawExpr='$movie.length')) # from line 192, col 11.
                write(''' min. / ''')
                _v = VFFSL(SL,"movie.filesize_readable",True) # '$movie.filesize_readable' on line 192, col 32
                if _v is not None: write(_filter(_v, rawExpr='$movie.filesize_readable')) # from line 192, col 32.
                write('''</span>
\t</div>
\t</div>

\t</div>
\t\t\t\t\t\t\t\t\t<div class="body">
\t\t\t\t\t\t\t\t\t\t<div class="row clearfix" style="margin-bottom:-25px;">
\t\t\t\t\t\t\t\t\t\t\t<div class="col-xs-12">
\t\t\t\t\t\t\t\t\t\t\t\t<span data-toggle="collapse" data-target="#eventid''')
                _v = VFFSL(SL,"count",True) # '$count' on line 200, col 63
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 200, col 63.
                write('''" aria-expanded="false"aria-controls="collapseExample" style="cursor:pointer;"><b>''')
                _v = VFFSL(SL,"movie.description",True) # '$movie.description' on line 200, col 151
                if _v is not None: write(_filter(_v, rawExpr='$movie.description')) # from line 200, col 151.
                write('''</b><i class="material-icons material-icons-centered">expand_more</i></span>
\t\t\t\t\t\t\t\t\t\t\t\t<div class="collapse" id="eventid''')
                _v = VFFSL(SL,"count",True) # '$count' on line 201, col 46
                if _v is not None: write(_filter(_v, rawExpr='$count')) # from line 201, col 46.
                write('''">
\t\t\t\t\t\t\t\t\t\t\t\t\t<p>''')
                _v = VFFSL(SL,"movie.descriptionExtended",True) # '$movie.descriptionExtended' on line 202, col 17
                if _v is not None: write(_filter(_v, rawExpr='$movie.descriptionExtended')) # from line 202, col 17.
                write('''</p>
\t\t\t\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t\t\t</div>
\t\t\t\t\t\t</div>
\t\t\t\t\t</div>
\t\t\t\t\t
''')
                count += 1
            write('''\t\t\t</div>
\t\t</div>
\t</div>
</div>

</div></div></div>

''')
        write("""
<script>
\tjQuery(function() {
\t\tMLHelper.Load('""")
        _v = VFFSL(SL,"sort",True) # '$sort' on line 224, col 18
        if _v is not None: write(_filter(_v, rawExpr='$sort')) # from line 224, col 18.
        write("""');
\t});
</script>
""")
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_moviesearch = 'respond'

## END CLASS DEFINITION

if not hasattr(moviesearch, '_initCheetahAttributes'):
    templateAPIClass = getattr(moviesearch,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(moviesearch)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=moviesearch()).run()


