# -*- coding:utf-8 -*-

ASCIItranslit = {
	0x0022: "''",
	0x002A: "_",
	0x002F: "_",
	0x003A: "_",
	0x003C: "_",
	0x003D: "_",
	0x003E: "_",
	0x003F: "_",
	0x005C: "_",
	0x007C: "_",
	0x007F: "",
	0x00A0: "_",
	0x00A1: "!",
	0x00A2: "c",
	0x00A3: "lb",
	0x00A4: "",
	0x00A5: "yen",
	0x00A6: "I",
	0x00A7: "SS",
	0x00A8: "'",
	0x00A9: "(c)",
	0x00AA: "a",
	0x00AB: "<<",
	0x00AC: "not",
	0x00AD: "-",
	0x00AE: "(R)",
	0x00AF: "",
	0x00B0: "^0",
	0x00B1: "+-",
	0x00B2: "^2",
	0x00B3: "^3",
	0x00B4: "'",
	0x00B5: "u",
	0x00B6: "P",
	0x00B7: ".",
	0x00B8: ",",
	0x00B9: "^1",
	0x00BA: "o",
	0x00BB: ">>",
	0x00BC: "1_4 ",
	0x00BD: "1_2 ",
	0x00BE: "3_4 ",
	0x00BF: "_",
	0x00C0: "`A",
	0x00C1: "'A",
	0x00C2: "^A",
	0x00C3: "~A",
	0x00C4: "Ae",
	0x00C5: "A",
	0x00C6: "AE",
	0x00C7: "C",
	0x00C8: "`E",
	0x00C9: "'E",
	0x00CA: "^E",
	0x00CB: "E",
	0x00CC: "`I",
	0x00CD: "'I",
	0x00CE: "^I",
	0x00CF: "I",
	0x00D0: "D",
	0x00D1: "~N",
	0x00D2: "`O",
	0x00D3: "'O",
	0x00D4: "^O",
	0x00D5: "~O",
	0x00D6: "Oe",
	0x00D7: "x",
	0x00D8: "O",
	0x00D9: "`U",
	0x00DA: "'U",
	0x00DB: "^U",
	0x00DC: "Ue",
	0x00DD: "'Y",
	0x00DE: "Th",
	0x00DF: "ss",
	0x00E0: "`a",
	0x00E1: "'a",
	0x00E2: "^a",
	0x00E3: "~a",
	0x00E4: "AE",
	0x00E5: "a",
	0x00E6: "ae",
	0x00E7: "c",
	0x00E8: "`e",
	0x00E9: "'e",
	0x00EA: "^e",
	0x00EB: "e",
	0x00EC: "`i",
	0x00ED: "'i",
	0x00EE: "^i",
	0x00EF: "i",
	0x00F0: "d",
	0x00F1: "~n",
	0x00F2: "`o",
	0x00F3: "'o",
	0x00F4: "^o",
	0x00F5: "~o",
	0x00F6: "oe",
	0x00F7: "_",
	0x00F8: "o",
	0x00F9: "`u",
	0x00FA: "'u",
	0x00FB: "^u",
	0x00FC: "ue",
	0x00FD: "'y",
	0x00FE: "th",
	0x00FF: "Y",
	0x0100: "A",
	0x0101: "a",
	0x0102: "A",
	0x0103: "a",
	0x0104: "A",
	0x0105: "a",
	0x0106: "'C",
	0x0107: "'c",
	0x0108: "^C",
	0x0109: "^c",
	0x010A: "C",
	0x010B: "c",
	0x010C: "C",
	0x010D: "c",
	0x010E: "D",
	0x010F: "d",
	0x0110: "D",
	0x0111: "d",
	0x0112: "E",
	0x0113: "e",
	0x0114: "E",
	0x0115: "e",
	0x0116: "E",
	0x0117: "e",
	0x0118: "E",
	0x0119: "e",
	0x011A: "E",
	0x011B: "e",
	0x011C: "^G",
	0x011D: "^g",
	0x011E: "G",
	0x011F: "g",
	0x0120: "G",
	0x0121: "g",
	0x0122: "G",
	0x0123: "g",
	0x0124: "^H",
	0x0125: "^h",
	0x0126: "H",
	0x0127: "h",
	0x0128: "~I",
	0x0129: "~i",
	0x012A: "I",
	0x012B: "i",
	0x012C: "I",
	0x012D: "i",
	0x012E: "I",
	0x012F: "i",
	0x0130: "I",
	0x0131: "i",
	0x0132: "IJ",
	0x0133: "ij",
	0x0134: "^J",
	0x0135: "^j",
	0x0136: "K",
	0x0137: "k",
	0x0138: "",
	0x0139: "L",
	0x013A: "l",
	0x013B: "L",
	0x013C: "l",
	0x013D: "L",
	0x013E: "l",
	0x013F: "L",
	0x0140: "l",
	0x0141: "L",
	0x0142: "l",
	0x0143: "'N",
	0x0144: "'n",
	0x0145: "N",
	0x0146: "n",
	0x0147: "N",
	0x0148: "n",
	0x0149: "n",
	0x014A: "_",
	0x014B: "_",
	0x014C: "O",
	0x014D: "o",
	0x014E: "O",
	0x014F: "o",
	0x0150: "''o",
	0x0152: "OE",
	0x0153: "oe",
	0x0154: "'R",
	0x0155: "'r",
	0x0156: "R",
	0x0157: "r",
	0x0158: "R",
	0x0159: "r",
	0x015A: "'s",
	0x015B: "'s",
	0x015C: "^S",
	0x015D: "^s",
	0x015E: "S",
	0x015F: "s",
	0x0160: "S",
	0x0161: "s",
	0x0162: "T",
	0x0163: "t",
	0x0164: "T",
	0x0165: "t",
	0x0166: "T",
	0x0167: "t",
	0x0168: "~U",
	0x0169: "~u",
	0x016A: "U",
	0x016B: "u",
	0x016C: "U",
	0x016D: "u",
	0x016E: "U",
	0x016F: "u",
	0x0170: "''u",
	0x0172: "U",
	0x0173: "u",
	0x0174: "^W",
	0x0175: "^w",
	0x0176: "^Y",
	0x0177: "^y",
	0x0178: "Y",
	0x0179: "'Z",
	0x017A: "'z",
	0x017B: "Z",
	0x017C: "z",
	0x017D: "Z",
	0x017E: "z",
	0x017F: "s",
	0x018F: "_",
	0x0192: "f",
	0x01C4: "DZ",
	0x01C5: "DZ",
	0x01C6: "DZ",
	0x01C7: "LJ",
	0x01C8: "Lj",
	0x01C9: "lj",
	0x01CA: "NJ",
	0x01CB: "Nj",
	0x01CC: "nj",
	0x01F1: "DZ",
	0x01F2: "Dz",
	0x01F3: "dz",
	0x0218: "S",
	0x0219: "s",
	0x021A: "T",
	0x021B: "t",
	0x0259: "_",
	0x20AC: "EUR"}


def legacyEncode(string):
	if isinstance(string, bytes):
		string = string.decode("utf-8")
	string2 = ""
	for z, char in enumerate(string):
		# print ("[legacyEncode] %d - %d" % (z, ord(char)))
		i = ord(char)
		if i < 33:
			string2 += "_"
		elif i in ASCIItranslit:
			string2 += ASCIItranslit[i]
		else:
			try:
				string2 += char.encode('ascii', 'strict').decode('utf8')
			except:
				string2 += "_"
	return string2.upper()
